/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

import edu.rit.color.HSB;
import edu.rit.image.ColorImage;
import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class MandelbrotSetSmp2 {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gamma;
    static File filename;
    static int xoffset;
    static int yoffset;
    static int[][] matrix;
    static ColorImage image;
    static int[] huetable;
    static long[] thr_t1;
    static long[] thr_t2;

    private MandelbrotSetSmp2() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        long l = System.currentTimeMillis();
        if (stringArray.length != 8) {
            MandelbrotSetSmp2.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gamma = Double.parseDouble(stringArray[6]);
        filename = new File(stringArray[7]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        matrix = new int[height][width];
        image = new ColorImage(matrix);
        huetable = new int[maxiter + 1];
        for (n = 0; n < maxiter; ++n) {
            MandelbrotSetSmp2.huetable[n] = HSB.pack((float)Math.pow((double)n / (double)maxiter, gamma), 1.0f, 1.0f);
        }
        MandelbrotSetSmp2.huetable[MandelbrotSetSmp2.maxiter] = HSB.pack(1.0f, 1.0f, 0.0f);
        n = ParallelTeam.getDefaultThreadCount();
        thr_t1 = new long[n];
        thr_t2 = new long[n];
        long l2 = System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                MandelbrotSetSmp2.thr_t1[this.getThreadIndex()] = System.currentTimeMillis();
                this.execute(0, height - 1, NO_WAIT, new IntegerForLoop(){

                    public void run(int n, int n2) {
                        for (int i = n; i <= n2; ++i) {
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n3;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                MandelbrotSetSmp2.matrix[i][j] = huetable[n3];
                            }
                        }
                    }
                });
                MandelbrotSetSmp2.thr_t2[this.getThreadIndex()] = System.currentTimeMillis();
            }
        });
        long l3 = System.currentTimeMillis();
        ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename)));
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        for (int i = 0; i < n; ++i) {
            System.out.println("\t" + (thr_t2[i] - thr_t1[i]) + " msec thread " + i);
        }
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.fractal.MandelbrotSetSmp2 <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <gamma> <filename>");
        System.err.println("<K> = Number of processors");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<gamma> = Used to calculate pixel hues");
        System.err.println("<filename> = PNG image file name");
        System.exit(1);
    }
}

