/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

import edu.rit.image.GrayImage;
import edu.rit.image.GrayImageRow;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import javax.imageio.ImageIO;

public class MandelbrotSetGray {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static double gmin;
    static double gmax;
    static double gslope;
    static File filename;
    static int xoffset;
    static int yoffset;
    static byte[][] matrix;
    static GrayImage image;
    static GrayImageRow imagerow;
    static float[] graytable;

    private MandelbrotSetGray() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 10) {
            MandelbrotSetGray.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        gmin = Double.parseDouble(stringArray[6]);
        gmax = Double.parseDouble(stringArray[7]);
        gslope = Double.parseDouble(stringArray[8]);
        filename = new File(stringArray[9]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        matrix = new byte[height][width];
        image = new GrayImage(matrix, GrayImage.ZERO_IS_WHITE);
        imagerow = new GrayImageRow(matrix, GrayImage.ZERO_IS_WHITE);
        graytable = new float[maxiter + 1];
        for (int i = 0; i < maxiter; ++i) {
            MandelbrotSetGray.graytable[i] = (float)Math.min(gmin + gslope * (double)i / (double)maxiter, gmax);
        }
        MandelbrotSetGray.graytable[MandelbrotSetGray.maxiter] = 1.0f;
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < height; ++i) {
            imagerow.row(i);
            double d = ycenter + (double)(yoffset - i) / resolution;
            for (int j = 0; j < width; ++j) {
                int n;
                double d2 = xcenter + (double)(xoffset + j) / resolution;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n = 0; n < maxiter && d7 <= 4.0; ++n) {
                    d5 = d3 * d3 - d4 * d4 + d2;
                    d6 = 2.0 * d3 * d4 + d;
                    d7 = d5 * d5 + d6 * d6;
                    d3 = d5;
                    d4 = d6;
                }
                imagerow.setPixel(j, graytable[n]);
            }
        }
        long l3 = System.currentTimeMillis();
        ImageIO.write((RenderedImage)image, "png", new BufferedOutputStream(new FileOutputStream(filename)));
        long l4 = System.currentTimeMillis();
        System.out.println(l2 - l + " msec pre");
        System.out.println(l3 - l2 + " msec calc");
        System.out.println(l4 - l3 + " msec post");
        System.out.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.smp.fractal.MandelbrotSetGray <width> <height> <xcenter> <ycenter> <resolution> <maxiter> <grayL> <grayU> <gamma> <filename>");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.err.println("<grayL> = Used to calculate pixel gray levels");
        System.err.println("<grayU> = Used to calculate pixel gray levels");
        System.err.println("<gamma> = Used to calculate pixel gray levels");
        System.err.println("<filename> = PNG image file name");
        System.exit(1);
    }
}

