/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

import edu.rit.pj.IntegerForLoop;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;

public class MSHistogramSmp3 {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static int xoffset;
    static int yoffset;
    static int[] histogram;

    private MSHistogramSmp3() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 6) {
            MSHistogramSmp3.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        histogram = new int[maxiter + 1];
        long l2 = System.currentTimeMillis();
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                this.execute(0, height - 1, new IntegerForLoop(){
                    int[] thr_histogram = new int[maxiter + 1 + 16];
                    long pad1;
                    long pad2;
                    long pad3;
                    long pad4;
                    long pad5;
                    long pad6;
                    long pad7;
                    long pad8;

                    public void run(int n, int n2) {
                        for (int i = n; i <= n2; ++i) {
                            double d = ycenter + (double)(yoffset - i) / resolution;
                            for (int j = 0; j < width; ++j) {
                                int n3;
                                double d2 = xcenter + (double)(xoffset + j) / resolution;
                                double d3 = 0.0;
                                double d4 = 0.0;
                                double d5 = 0.0;
                                double d6 = 0.0;
                                double d7 = 0.0;
                                for (n3 = 0; n3 < maxiter && d7 <= 4.0; ++n3) {
                                    d5 = d3 * d3 - d4 * d4 + d2;
                                    d6 = 2.0 * d3 * d4 + d;
                                    d7 = d5 * d5 + d6 * d6;
                                    d3 = d5;
                                    d4 = d6;
                                }
                                int n4 = n3;
                                this.thr_histogram[n4] = this.thr_histogram[n4] + 1;
                            }
                        }
                    }

                    public void finish() throws Exception {
                        this.region().critical(new ParallelSection(){

                            public void run() {
                                for (int i = 0; i <= maxiter; ++i) {
                                    int n = i;
                                    histogram[n] = histogram[n] + thr_histogram[i];
                                }
                            }
                        });
                    }
                });
            }
        });
        long l3 = System.currentTimeMillis();
        for (int i = 0; i <= maxiter; ++i) {
            System.out.print(i);
            System.out.print('\t');
            System.out.print(histogram[i]);
            System.out.println();
        }
        long l4 = System.currentTimeMillis();
        System.err.println(l2 - l + " msec pre");
        System.err.println(l3 - l2 + " msec calc");
        System.err.println(l4 - l3 + " msec post");
        System.err.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.smp.fractal.MSHistogramSmp3 <width> <height> <xcenter> <ycenter> <resolution> <maxiter>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.exit(1);
    }
}

