/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.smp.fractal;

public class MSHistogramSeq {
    static int width;
    static int height;
    static double xcenter;
    static double ycenter;
    static double resolution;
    static int maxiter;
    static int xoffset;
    static int yoffset;
    static int[] histogram;

    private MSHistogramSeq() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = System.currentTimeMillis();
        if (stringArray.length != 6) {
            MSHistogramSeq.usage();
        }
        width = Integer.parseInt(stringArray[0]);
        height = Integer.parseInt(stringArray[1]);
        xcenter = Double.parseDouble(stringArray[2]);
        ycenter = Double.parseDouble(stringArray[3]);
        resolution = Double.parseDouble(stringArray[4]);
        maxiter = Integer.parseInt(stringArray[5]);
        xoffset = -(width - 1) / 2;
        yoffset = (height - 1) / 2;
        histogram = new int[maxiter + 1];
        long l2 = System.currentTimeMillis();
        for (int i = 0; i < height; ++i) {
            double d = ycenter + (double)(yoffset - i) / resolution;
            for (int j = 0; j < width; ++j) {
                int n;
                double d2 = xcenter + (double)(xoffset + j) / resolution;
                double d3 = 0.0;
                double d4 = 0.0;
                double d5 = 0.0;
                double d6 = 0.0;
                double d7 = 0.0;
                for (n = 0; n < maxiter && d7 <= 4.0; ++n) {
                    d5 = d3 * d3 - d4 * d4 + d2;
                    d6 = 2.0 * d3 * d4 + d;
                    d7 = d5 * d5 + d6 * d6;
                    d3 = d5;
                    d4 = d6;
                }
                int n2 = n;
                histogram[n2] = histogram[n2] + 1;
            }
        }
        long l3 = System.currentTimeMillis();
        for (int i = 0; i <= maxiter; ++i) {
            System.out.print(i);
            System.out.print('\t');
            System.out.print(histogram[i]);
            System.out.println();
        }
        long l4 = System.currentTimeMillis();
        System.err.println(l2 - l + " msec pre");
        System.err.println(l3 - l2 + " msec calc");
        System.err.println(l4 - l3 + " msec post");
        System.err.println(l4 - l + " msec total");
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.smp.fractal.MSHistogramSeq <width> <height> <xcenter> <ycenter> <resolution> <maxiter>");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<xcenter> = X coordinate of center point");
        System.err.println("<ycenter> = Y coordinate of center point");
        System.err.println("<resolution> = Pixels per unit");
        System.err.println("<maxiter> = Maximum number of iterations");
        System.exit(1);
    }
}

