/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.test;

import edu.rit.crypto.blockcipher.AES256CipherSmp;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.util.Range;

public class Test12 {
    static int N1;
    static int N2;
    static int N3;
    static byte[][] block;

    private Test12() {
    }

    public static void main(String[] stringArray) throws Exception {
        long l = -System.currentTimeMillis();
        if (stringArray.length != 3) {
            Test12.usage();
        }
        N1 = Integer.parseInt(stringArray[0]);
        N2 = Integer.parseInt(stringArray[1]);
        N3 = Integer.parseInt(stringArray[2]);
        block = new byte[N2][80];
        new ParallelTeam().execute(new ParallelRegion(){

            public void run() throws Exception {
                Range range = new Range(0, N2 - 1).subrange(this.getThreadCount(), this.getThreadIndex());
                int n = range.lb();
                int n2 = range.ub();
                AES256CipherSmp aES256CipherSmp = new AES256CipherSmp(new byte[32]);
                for (int i = 0; i < N1; ++i) {
                    for (int j = n; j <= n2; ++j) {
                        byte[] byArray = block[j];
                        for (int k = 0; k < N3; ++k) {
                            aES256CipherSmp.encrypt(byArray, byArray);
                        }
                    }
                    this.barrier();
                }
            }
        });
        System.out.println(l += System.currentTimeMillis());
    }

    private static void usage() {
        System.err.println("Usage: java -Dpj.nt=<K> edu.rit.pj.test.Test12 <N1> <N2> <N3>");
        System.err.println("<K> = Number of parallel threads");
        System.err.println("<N1> = Number of outer loop iterations");
        System.err.println("<N2> = Number of middle loop iterations");
        System.err.println("<N3> = Number of inner loop iterations");
        System.exit(1);
    }
}

