/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.reduction;

import edu.rit.pj.reduction.ObjectOp;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SharedObjectArray<T> {
    private AtomicReferenceArray<T> myArray;

    public SharedObjectArray(int n) {
        this.myArray = new AtomicReferenceArray(n);
    }

    public SharedObjectArray(T[] TArray) {
        this.myArray = new AtomicReferenceArray<T>(TArray);
    }

    public int length() {
        return this.myArray.length();
    }

    public T get(int n) {
        return this.myArray.get(n);
    }

    public void set(int n, T t) {
        this.myArray.set(n, t);
    }

    public T getAndSet(int n, T t) {
        return this.myArray.getAndSet(n, t);
    }

    public boolean compareAndSet(int n, T t, T t2) {
        return this.myArray.compareAndSet(n, t, t2);
    }

    public boolean weakCompareAndSet(int n, T t, T t2) {
        return this.myArray.weakCompareAndSet(n, t, t2);
    }

    public T reduce(int n, T t, ObjectOp<T> objectOp) {
        T t2;
        T t3;
        while (!this.myArray.compareAndSet(n, t3 = this.myArray.get(n), t2 = objectOp.op(t3, t))) {
        }
        return t2;
    }

    public void reduce(T[] TArray, ObjectOp<T> objectOp) {
        this.reduce(0, TArray, 0, this.myArray.length(), objectOp);
    }

    public void reduce(int n, T[] TArray, int n2, int n3, ObjectOp<T> objectOp) {
        if (n3 < 0 || n < 0 || n + n3 > this.myArray.length() || n2 < 0 || n2 + n3 > TArray.length) {
            throw new IndexOutOfBoundsException();
        }
        while (n3 > 0) {
            T t;
            T t2;
            while (!this.myArray.compareAndSet(n, t2 = this.myArray.get(n), t = objectOp.op(t2, TArray[n2]))) {
            }
            ++n;
            ++n2;
            --n3;
        }
    }

    public String toString() {
        return this.myArray.toString();
    }
}

