/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.Message;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public abstract class JobSchedulerMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = -7379945472003527741L;

    public JobSchedulerMessage() {
    }

    public JobSchedulerMessage(int n) {
        super(n);
    }

    public static JobSchedulerMessage backendFailed(JobFrontendRef jobFrontendRef, String string) {
        return new BackendFailedMessage(jobFrontendRef, string);
    }

    public static JobSchedulerMessage cancelJob(JobFrontendRef jobFrontendRef, String string) {
        return new CancelJobMessage(jobFrontendRef, string);
    }

    public static JobSchedulerMessage jobFinished(JobFrontendRef jobFrontendRef) {
        return new JobFinishedMessage(jobFrontendRef);
    }

    public static JobSchedulerMessage renewLease(JobFrontendRef jobFrontendRef) {
        return new RenewLeaseMessage(jobFrontendRef);
    }

    public static JobSchedulerMessage requestJob(JobFrontendRef jobFrontendRef, String string, int n) {
        return new RequestJobMessage(jobFrontendRef, string, n);
    }

    public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
    }

    private static class RequestJobMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -2335772918585461904L;
        private String username;
        private int K;

        public RequestJobMessage() {
        }

        public RequestJobMessage(JobFrontendRef jobFrontendRef, String string, int n) {
            super(2);
            this.username = string;
            this.K = n;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.requestJob(jobFrontendRef, this.username, this.K);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.username);
            objectOutput.writeInt(this.K);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.username = objectInput.readUTF();
            this.K = objectInput.readInt();
        }
    }

    private static class RenewLeaseMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 8547605668292095227L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobFrontendRef jobFrontendRef) {
            super(2);
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.renewLease(jobFrontendRef);
        }
    }

    private static class JobFinishedMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = -1179228962545666153L;

        public JobFinishedMessage() {
        }

        public JobFinishedMessage(JobFrontendRef jobFrontendRef) {
            super(2);
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.jobFinished(jobFrontendRef);
        }
    }

    private static class CancelJobMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 2902818757044365344L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobFrontendRef jobFrontendRef, String string) {
            super(2);
            this.errmsg = string;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.cancelJob(jobFrontendRef, this.errmsg);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.errmsg);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.errmsg = objectInput.readUTF();
        }
    }

    private static class BackendFailedMessage
    extends JobSchedulerMessage {
        private static final long serialVersionUID = 6495614788809259018L;
        private String name;

        public BackendFailedMessage() {
        }

        public BackendFailedMessage(JobFrontendRef jobFrontendRef, String string) {
            super(2);
            this.name = string;
        }

        public void invoke(JobSchedulerRef jobSchedulerRef, JobFrontendRef jobFrontendRef) throws IOException {
            jobSchedulerRef.backendFailed(jobFrontendRef, this.name);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.name);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.name = objectInput.readUTF();
        }
    }
}

