/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.http.HttpRequest;
import edu.rit.http.HttpResponse;
import edu.rit.http.HttpServer;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.ChannelGroupClosedException;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.mp.buf.ObjectItemBuf;
import edu.rit.pj.cluster.BackendInfo;
import edu.rit.pj.cluster.Configuration;
import edu.rit.pj.cluster.JobFrontendProxy;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobInfo;
import edu.rit.pj.cluster.JobSchedulerMessage;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.util.Timer;
import edu.rit.util.TimerTask;
import edu.rit.util.TimerThread;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class JobScheduler
implements JobSchedulerRef {
    private String myClusterName;
    private PrintWriter myLogFile;
    private String myWebHost;
    private int myWebPort;
    private String mySchedulerHost;
    private int mySchedulerPort;
    private String myFrontendHost;
    private Map<String, BackendInfo> myNameToBackendMap = new TreeMap<String, BackendInfo>();
    private int myOperationalBackendCount;
    private List<BackendInfo> myIdleBackendList = new LinkedList<BackendInfo>();
    private int myNextJobNumber = 1;
    private Map<JobFrontendRef, JobInfo> myFrontendToJobMap = new HashMap<JobFrontendRef, JobInfo>();
    private List<JobInfo> myRunningJobList = new LinkedList<JobInfo>();
    private List<JobInfo> myWaitingJobList = new LinkedList<JobInfo>();
    private TimerThread myLeaseTimerThread;
    private ChannelGroup myChannelGroup;
    private HttpServer myHttpServer;
    private long myTotalComputeTime;

    private JobScheduler(String string) throws IOException {
        long l = System.currentTimeMillis();
        Configuration configuration = new Configuration(string);
        this.myClusterName = configuration.getClusterName();
        this.myLogFile = new PrintWriter((Writer)new FileWriter(configuration.getLogFile(), true), true);
        this.myWebHost = configuration.getWebHost();
        this.myWebPort = configuration.getWebPort();
        this.mySchedulerHost = configuration.getSchedulerHost();
        this.mySchedulerPort = configuration.getSchedulerPort();
        this.myFrontendHost = configuration.getFrontendHost();
        for (BackendInfo backendInfo : configuration.getBackendInfoList()) {
            this.myNameToBackendMap.put(backendInfo.name, backendInfo);
            ++this.myOperationalBackendCount;
            this.myIdleBackendList.add(backendInfo);
        }
        this.log(l, "Started");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                JobScheduler.this.shutdown();
            }
        });
        this.myLeaseTimerThread = new TimerThread();
        this.myLeaseTimerThread.setDaemon(true);
        this.myLeaseTimerThread.start();
        this.myChannelGroup = new ChannelGroup(new InetSocketAddress(this.mySchedulerHost, this.mySchedulerPort));
        this.log(l, "Job Scheduler at " + this.myChannelGroup.listenAddress());
        this.myHttpServer = new HttpServer(new InetSocketAddress(this.myWebHost, this.myWebPort)){

            protected void process(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
                JobScheduler.this.processHttpRequest(httpRequest, httpResponse);
            }
        };
        this.log(l, "Web interface at " + this.myHttpServer.getAddress());
        for (BackendInfo backendInfo : this.myNameToBackendMap.values()) {
            this.log(l, "Backend " + backendInfo.name + " at " + backendInfo.host);
        }
    }

    private void run() {
        ObjectItemBuf<JobSchedulerMessage> objectItemBuf = ObjectBuf.buffer((JobSchedulerMessage)null);
        Status status = null;
        JobSchedulerMessage jobSchedulerMessage = null;
        JobFrontendRef jobFrontendRef = null;
        try {
            while (true) {
                status = this.myChannelGroup.receive(null, null, objectItemBuf);
                jobSchedulerMessage = (JobSchedulerMessage)objectItemBuf.item;
                jobFrontendRef = (JobFrontendRef)status.channel.info();
                if (jobFrontendRef == null) {
                    jobFrontendRef = new JobFrontendProxy(this.myChannelGroup, status.channel);
                    status.channel.info(jobFrontendRef);
                }
                jobSchedulerMessage.invoke(this, jobFrontendRef);
                objectItemBuf.item = null;
                status = null;
                jobSchedulerMessage = null;
                jobFrontendRef = null;
            }
        }
        catch (ChannelGroupClosedException channelGroupClosedException) {
        }
        catch (Throwable throwable) {
            this.log(throwable);
        }
    }

    public synchronized void backendFailed(JobFrontendRef jobFrontendRef, String string) throws IOException {
        BackendInfo backendInfo = this.myNameToBackendMap.get(string);
        if (backendInfo != null) {
            long l = System.currentTimeMillis();
            this.log(l, "Backend " + string + " failed");
        }
    }

    public synchronized void cancelJob(JobFrontendRef jobFrontendRef, String string) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        this.doCancelJob(System.currentTimeMillis(), jobInfo, string);
    }

    public synchronized void jobFinished(JobFrontendRef jobFrontendRef) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        this.doFinishJob(System.currentTimeMillis(), jobInfo);
    }

    public synchronized void renewLease(JobFrontendRef jobFrontendRef) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        jobInfo.expireTimer.start(150000L);
    }

    public synchronized void requestJob(JobFrontendRef jobFrontendRef, String string, int n) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        long l = jobInfo.stateTime;
        this.log(l, "Job " + jobInfo.jobnum + " queued, username=" + string + ", K=" + n);
        jobInfo.username = string;
        jobInfo.K = n;
        jobInfo.backend = new BackendInfo[n];
        if (this.myOperationalBackendCount < n) {
            this.doCancelJobTooFewProcessors(l, jobInfo);
            return;
        }
        this.myWaitingJobList.add(jobInfo);
        jobInfo.renewTimer.start(60000L, 60000L);
        jobInfo.expireTimer.start(150000L);
        jobFrontendRef.assignJobNumber(this, jobInfo.jobnum, this.myFrontendHost);
        this.assignProcessorsToJobs(l);
    }

    public void close() {
    }

    private synchronized void renewTimeout(JobFrontendRef jobFrontendRef) throws IOException {
        jobFrontendRef.renewLease(this);
    }

    private synchronized void expireTimeout(JobFrontendRef jobFrontendRef) throws IOException {
        JobInfo jobInfo = this.getJobInfo(jobFrontendRef);
        this.doCancelJob(System.currentTimeMillis(), jobInfo, "Job frontend lease expired");
    }

    private JobInfo getJobInfo(JobFrontendRef jobFrontendRef) {
        final JobFrontendRef jobFrontendRef2 = jobFrontendRef;
        JobInfo jobInfo = this.myFrontendToJobMap.get(jobFrontendRef);
        if (jobInfo == null) {
            jobInfo = new JobInfo(this.myNextJobNumber++, JobInfo.State.WAITING, System.currentTimeMillis(), null, 0, 0, null, jobFrontendRef2, this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobScheduler.this.renewTimeout(jobFrontendRef2);
                    }
                    catch (Throwable throwable) {
                        JobScheduler.this.log(throwable);
                    }
                }
            }), this.myLeaseTimerThread.createTimer(new TimerTask(){

                public void action(Timer timer) {
                    try {
                        JobScheduler.this.expireTimeout(jobFrontendRef2);
                    }
                    catch (Throwable throwable) {
                        JobScheduler.this.log(throwable);
                    }
                }
            }));
            this.myFrontendToJobMap.put(jobFrontendRef, jobInfo);
        }
        return jobInfo;
    }

    private void doFinishJob(long l, JobInfo jobInfo) throws IOException {
        this.log(l, "Job " + jobInfo.jobnum + " finished");
        this.doCleanupJob(l, jobInfo);
    }

    private void doCancelJob(long l, JobInfo jobInfo, String string) throws IOException {
        this.log(l, "Job " + jobInfo.jobnum + " canceled: " + string);
        this.doCleanupJob(l, jobInfo);
    }

    private void doCancelJobTooFewProcessors(long l, JobInfo jobInfo) throws IOException {
        String string = "Too few processors -- " + jobInfo.K + " requested, " + this.myOperationalBackendCount + " available";
        jobInfo.frontend.cancelJob(this, string);
        this.doCancelJob(l, jobInfo, string);
    }

    private void doCleanupJob(long l, JobInfo jobInfo) throws IOException {
        jobInfo.renewTimer.stop();
        jobInfo.expireTimer.stop();
        jobInfo.frontend.close();
        this.myFrontendToJobMap.remove(jobInfo.frontend);
        this.myRunningJobList.remove(jobInfo);
        this.myWaitingJobList.remove(jobInfo);
        for (int i = 0; i < jobInfo.count; ++i) {
            BackendInfo backendInfo = jobInfo.backend[i];
            if (backendInfo.state == BackendInfo.State.FAILED) continue;
            backendInfo.state = BackendInfo.State.IDLE;
            backendInfo.stateTime = l;
            backendInfo.job = null;
            this.myIdleBackendList.add(backendInfo);
        }
        this.myTotalComputeTime += (l - jobInfo.stateTime) * (long)jobInfo.K;
        this.assignProcessorsToJobs(l);
    }

    private void assignProcessorsToJobs(long l) throws IOException {
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator<JobInfo> iterator = this.myWaitingJobList.iterator();
        while (iterator.hasNext()) {
            JobInfo jobInfo = iterator.next();
            if (this.myOperationalBackendCount < jobInfo.K) {
                iterator.remove();
                linkedList.add(jobInfo);
                continue;
            }
            while (jobInfo.count < jobInfo.K && !this.myIdleBackendList.isEmpty()) {
                BackendInfo backendInfo = this.myIdleBackendList.remove(0);
                this.log(l, "Job " + jobInfo.jobnum + " assigned " + backendInfo.name);
                backendInfo.state = BackendInfo.State.RESERVED;
                backendInfo.stateTime = l;
                backendInfo.job = jobInfo;
                jobInfo.backend[jobInfo.count++] = backendInfo;
                jobInfo.frontend.assignBackend(this, backendInfo.name, backendInfo.host, backendInfo.jvm, backendInfo.classpath, backendInfo.jvmflags);
            }
            if (jobInfo.count != jobInfo.K) continue;
            this.log(l, "Job " + jobInfo.jobnum + " started");
            iterator.remove();
            this.myRunningJobList.add(jobInfo);
            jobInfo.state = JobInfo.State.RUNNING;
            jobInfo.stateTime = l;
            boolean i = false;
            while (jobInfo < jobInfo.count) {
                BackendInfo backendInfo = jobInfo.backend[jobInfo];
                backendInfo.state = BackendInfo.State.RUNNING;
                backendInfo.stateTime = l;
                ++jobInfo;
            }
        }
        for (JobInfo jobInfo : linkedList) {
            this.doCancelJobTooFewProcessors(l, jobInfo);
        }
    }

    private void log(String string) {
        this.log(System.currentTimeMillis(), string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(long l, String string) {
        if (this.myLogFile != null) {
            PrintWriter printWriter = this.myLogFile;
            synchronized (printWriter) {
                this.myLogFile.println(new Date(l) + " " + string);
            }
        }
    }

    private void log(Throwable throwable) {
        this.log(System.currentTimeMillis(), throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void log(long l, Throwable throwable) {
        if (this.myLogFile != null) {
            PrintWriter printWriter = this.myLogFile;
            synchronized (printWriter) {
                this.myLogFile.print(new Date(l) + " ");
                throwable.printStackTrace(this.myLogFile);
            }
        }
    }

    private synchronized void processHttpRequest(HttpRequest httpRequest, HttpResponse httpResponse) throws IOException {
        long l = System.currentTimeMillis();
        if (!httpRequest.isValid()) {
            httpResponse.setStatusCode(HttpResponse.Status.STATUS_400_BAD_REQUEST);
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            printWriter.println("<P>");
            printWriter.println("400 Bad Request");
            this.printStatusHtmlEnd(printWriter);
        } else if (!httpRequest.getMethod().equals("GET")) {
            httpResponse.setStatusCode(HttpResponse.Status.STATUS_501_NOT_IMPLEMENTED);
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            printWriter.println("<P>");
            printWriter.println("501 Not Implemented");
            this.printStatusHtmlEnd(printWriter);
        } else if (!httpRequest.getUri().equals("/") && !httpRequest.getUri().equals("/?")) {
            httpResponse.setStatusCode(HttpResponse.Status.STATUS_404_NOT_FOUND);
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            printWriter.println("<P>");
            printWriter.println("404 Not Found");
            this.printStatusHtmlEnd(printWriter);
        } else {
            PrintWriter printWriter = httpResponse.getPrintWriter();
            this.printStatusHtmlStart(printWriter, l);
            this.printStatusHtmlBody(printWriter, l);
            this.printStatusHtmlEnd(printWriter);
        }
        httpResponse.close();
    }

    private void printStatusHtmlStart(PrintWriter printWriter, long l) {
        printWriter.println("<HTML>");
        printWriter.println("<HEAD>");
        printWriter.print("<TITLE>");
        printWriter.print(this.myClusterName);
        printWriter.println("</TITLE>");
        printWriter.print("<META HTTP-EQUIV=\"refresh\" CONTENT=\"20;url=");
        this.printWebInterfaceURL(printWriter);
        printWriter.println("\">");
        printWriter.println("<STYLE TYPE=\"text/css\">");
        printWriter.println("<!--");
        printWriter.println("* {font-family: Arial, Helvetica, Sans-Serif;}");
        printWriter.println("body {font-size: small;}");
        printWriter.println("h1 {font-size: 140%; font-weight: bold;}");
        printWriter.println("table {font-size: 100%;}");
        printWriter.println("-->");
        printWriter.println("</STYLE>");
        printWriter.println("</HEAD>");
        printWriter.println("<BODY>");
        printWriter.print("<H1>");
        printWriter.print(this.myClusterName);
        printWriter.println("</H1>");
        printWriter.println("<P>");
        printWriter.print("<FORM ACTION=\"");
        this.printWebInterfaceURL(printWriter);
        printWriter.println("\" METHOD=\"get\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        printWriter.print("<INPUT TYPE=\"submit\" VALUE=\"Refresh\">");
        printWriter.println("</TD>");
        printWriter.println("<TD WIDTH=20> </TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"center\">");
        printWriter.print(new Date(l));
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</FORM>");
    }

    private void printStatusHtmlBody(PrintWriter printWriter, long l) {
        printWriter.println("<P>");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.println("Processors");
        printWriter.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printBackendLabels(printWriter);
        int n = 0;
        for (BackendInfo object : this.myNameToBackendMap.values()) {
            this.printBackendInfo(printWriter, l, object, n);
            ++n;
        }
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("<TD WIDTH=40> </TD>");
        printWriter.println("<TD ALIGN=\"center\" VALIGN=\"top\">");
        printWriter.println("Jobs");
        printWriter.println("<TABLE BORDER=1 CELLPADDING=3 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=3 CELLSPACING=0>");
        this.printJobLabels(printWriter);
        n = 0;
        for (JobInfo jobInfo : this.myRunningJobList) {
            this.printJobInfo(printWriter, l, jobInfo, n);
            ++n;
        }
        for (JobInfo jobInfo : this.myWaitingJobList) {
            this.printJobInfo(printWriter, l, jobInfo, n);
            ++n;
        }
        printWriter.println("</TABLE>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        this.printTotalComputeTime(printWriter);
        printWriter.print("<BR>");
        this.printJobCount(printWriter);
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
    }

    private void printJobCount(PrintWriter printWriter) {
        if (this.myNextJobNumber == 2) {
            printWriter.print("1 job");
        } else {
            printWriter.print(this.myNextJobNumber - 1);
            printWriter.print(" jobs");
        }
        printWriter.println(" served");
    }

    private void printTotalComputeTime(PrintWriter printWriter) {
        if (this.myTotalComputeTime < 1000000L) {
            printWriter.print(this.myTotalComputeTime / 1000L);
        } else if (this.myTotalComputeTime < 1000000000L) {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000L);
            printWriter.print(" thousand");
        } else if (this.myTotalComputeTime < 1000000000000L) {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000000L);
            printWriter.print(" million");
        } else if (this.myTotalComputeTime < 1000000000000000L) {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000000000L);
            printWriter.print(" billion");
        } else {
            printWriter.print("Over ");
            printWriter.print(this.myTotalComputeTime / 1000000000000L);
            printWriter.print(" trillion");
        }
        printWriter.println(" CPU seconds served");
    }

    private void printStatusHtmlEnd(PrintWriter printWriter) {
        printWriter.println("<P>");
        printWriter.println("<TABLE BORDER=0 CELLPADDING=0 CELLSPACING=0>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("Web interface:&nbsp;&nbsp;");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<A HREF=\"");
        this.printWebInterfaceURL(printWriter);
        printWriter.print("\">");
        this.printWebInterfaceURL(printWriter);
        printWriter.println("</A>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("Powered by Parallel Java:&nbsp;&nbsp;");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<A HREF=\"http://www.cs.rit.edu/~ark/pj.shtml\">http://www.cs.rit.edu/~ark/pj.shtml</A>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("<TR>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("Developed by Alan Kaminsky:&nbsp;&nbsp;");
        printWriter.println("</TD>");
        printWriter.println("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.println("<A HREF=\"http://www.cs.rit.edu/~ark/\">http://www.cs.rit.edu/~ark/</A>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
        printWriter.println("</TABLE>");
        printWriter.println("</BODY>");
        printWriter.println("</HTML>");
    }

    private void printWebInterfaceURL(PrintWriter printWriter) {
        printWriter.print("http://");
        printWriter.print(this.myWebHost);
        printWriter.print(":");
        printWriter.print(this.myWebPort);
        printWriter.print("/");
    }

    private void printDeltaTime(PrintWriter printWriter, long l, long l2) {
        printWriter.print((l - l2 + 500L) / 1000L);
        printWriter.print(" sec");
    }

    private void printBackendLabels(PrintWriter printWriter) {
        printWriter.println("<TR BGCOLOR=\"#E8E8E8\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Processor</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Status</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Job</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Time</I>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printBackendInfo(PrintWriter printWriter, long l, BackendInfo backendInfo, int n) {
        printWriter.print("<TR BGCOLOR=\"#");
        printWriter.print(n % 2 == 0 ? "FFFFFF" : "E8E8E8");
        printWriter.println("\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(backendInfo.name);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (backendInfo.state == BackendInfo.State.FAILED) {
            printWriter.print("<FONT COLOR=\"#FF0000\"><B>");
            printWriter.print((Object)backendInfo.state);
            printWriter.print("</B></FONT>");
        } else {
            printWriter.print((Object)backendInfo.state);
        }
        printWriter.println("</TD>");
        switch (backendInfo.state) {
            case IDLE: 
            case FAILED: {
                printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
                printWriter.print("&nbsp;");
                printWriter.println("</TD>");
                printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
                printWriter.print("&nbsp;");
                printWriter.println("</TD>");
                break;
            }
            case RESERVED: 
            case RUNNING: {
                printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
                printWriter.print(backendInfo.job.jobnum);
                printWriter.println("</TD>");
                printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
                this.printDeltaTime(printWriter, l, backendInfo.stateTime);
                printWriter.println("</TD>");
            }
        }
        printWriter.println("</TR>");
    }

    private void printJobLabels(PrintWriter printWriter) {
        printWriter.println("<TR BGCOLOR=\"#E8E8E8\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Job</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>User</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>K</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Processors</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Status</I>");
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print("<I>Time</I>");
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void printJobInfo(PrintWriter printWriter, long l, JobInfo jobInfo, int n) {
        printWriter.print("<TR BGCOLOR=\"#");
        printWriter.print(n % 2 == 0 ? "FFFFFF" : "E8E8E8");
        printWriter.println("\">");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.jobnum);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.username);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print(jobInfo.K);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        if (jobInfo.count == 0) {
            printWriter.print("&nbsp;");
        } else {
            printWriter.print(jobInfo.backend[0].name);
            for (int i = 1; i < jobInfo.count; ++i) {
                printWriter.print("<BR>");
                printWriter.print(jobInfo.backend[i].name);
            }
        }
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        printWriter.print((Object)jobInfo.state);
        printWriter.println("</TD>");
        printWriter.print("<TD ALIGN=\"left\" VALIGN=\"top\">");
        this.printDeltaTime(printWriter, l, jobInfo.stateTime);
        printWriter.println("</TD>");
        printWriter.println("</TR>");
    }

    private void shutdown() {
        if (this.myChannelGroup != null) {
            this.myChannelGroup.close();
        }
        if (this.myHttpServer != null) {
            try {
                this.myHttpServer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.log("Stopped");
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            System.err.println("Usage: java edu.rit.pj.cluster.JobScheduler <configfile>");
            System.exit(1);
        }
        JobScheduler jobScheduler = new JobScheduler(stringArray[0]);
        jobScheduler.run();
    }
}

