/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.JobSchedulerRef;
import edu.rit.pj.cluster.Message;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.InetSocketAddress;

public abstract class JobFrontendMessage
extends Message
implements Externalizable {
    private static final long serialVersionUID = -294465313248920647L;

    public JobFrontendMessage() {
    }

    public JobFrontendMessage(int n) {
        super(n);
    }

    public static JobFrontendMessage assignBackend(JobSchedulerRef jobSchedulerRef, String string, String string2, String string3, String string4, String[] stringArray) {
        return new AssignBackendMessage(jobSchedulerRef, string, string2, string3, string4, stringArray);
    }

    public static JobFrontendMessage assignJobNumber(JobSchedulerRef jobSchedulerRef, int n, String string) {
        return new AssignJobNumberMessage(jobSchedulerRef, n, string);
    }

    public static JobFrontendMessage cancelJob(JobSchedulerRef jobSchedulerRef, String string) {
        return new CancelJobMessage(jobSchedulerRef, string);
    }

    public static JobFrontendMessage renewLease(JobSchedulerRef jobSchedulerRef) {
        return new RenewLeaseMessage(jobSchedulerRef);
    }

    public static JobFrontendMessage backendFinished(JobBackendRef jobBackendRef) {
        return new BackendFinishedMessage(jobBackendRef);
    }

    public static JobFrontendMessage backendReady(JobBackendRef jobBackendRef, int n, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3) {
        return new BackendReadyMessage(jobBackendRef, n, inetSocketAddress, inetSocketAddress2, inetSocketAddress3);
    }

    public static JobFrontendMessage cancelJob(JobBackendRef jobBackendRef, String string) {
        return new CancelJobMessage(jobBackendRef, string);
    }

    public static JobFrontendMessage renewLease(JobBackendRef jobBackendRef) {
        return new RenewLeaseMessage(jobBackendRef);
    }

    public static JobFrontendMessage requestResource(JobBackendRef jobBackendRef, String string) {
        return new RequestResourceMessage(jobBackendRef, string);
    }

    public static JobFrontendMessage outputFileOpen(JobBackendRef jobBackendRef, int n, File file, boolean bl) {
        return new OutputFileOpenMessage(jobBackendRef, n, file, bl);
    }

    public static JobFrontendMessage outputFileWrite(JobBackendRef jobBackendRef, int n, int n2) {
        return new OutputFileWriteMessage(jobBackendRef, n, n2);
    }

    public static JobFrontendMessage outputFileFlush(JobBackendRef jobBackendRef, int n) {
        return new OutputFileFlushMessage(jobBackendRef, n);
    }

    public static JobFrontendMessage outputFileClose(JobBackendRef jobBackendRef, int n) {
        return new OutputFileCloseMessage(jobBackendRef, n);
    }

    public static JobFrontendMessage inputFileOpen(JobBackendRef jobBackendRef, int n, File file) {
        return new InputFileOpenMessage(jobBackendRef, n, file);
    }

    public static JobFrontendMessage inputFileRead(JobBackendRef jobBackendRef, int n, int n2) {
        return new InputFileReadMessage(jobBackendRef, n, n2);
    }

    public static JobFrontendMessage inputFileSkip(JobBackendRef jobBackendRef, int n, long l) {
        return new InputFileSkipMessage(jobBackendRef, n, l);
    }

    public static JobFrontendMessage inputFileClose(JobBackendRef jobBackendRef, int n) {
        return new InputFileCloseMessage(jobBackendRef, n);
    }

    public void invoke(JobFrontendRef jobFrontendRef, JobSchedulerRef jobSchedulerRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    private static class InputFileCloseMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 1223549294646718409L;
        private int ffd;

        public InputFileCloseMessage() {
        }

        public InputFileCloseMessage(JobBackendRef jobBackendRef, int n) {
            super(1);
            this.ffd = n;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.inputFileClose(jobBackendRef, this.ffd);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.ffd = objectInput.readInt();
        }
    }

    private static class InputFileSkipMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 7867427744015166954L;
        private int ffd;
        private long len;

        public InputFileSkipMessage() {
        }

        public InputFileSkipMessage(JobBackendRef jobBackendRef, int n, long l) {
            super(1);
            this.ffd = n;
            this.len = l;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.inputFileSkip(jobBackendRef, this.ffd, this.len);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeLong(this.len);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.ffd = objectInput.readInt();
            this.len = objectInput.readLong();
        }
    }

    private static class InputFileReadMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 7727558874589005187L;
        private int ffd;
        private int len;

        public InputFileReadMessage() {
        }

        public InputFileReadMessage(JobBackendRef jobBackendRef, int n, int n2) {
            super(1);
            this.ffd = n;
            this.len = n2;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.inputFileRead(jobBackendRef, this.ffd, this.len);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeInt(this.len);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.ffd = objectInput.readInt();
            this.len = objectInput.readInt();
        }
    }

    private static class InputFileOpenMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -791306998166025239L;
        private int bfd;
        private File file;

        public InputFileOpenMessage() {
        }

        public InputFileOpenMessage(JobBackendRef jobBackendRef, int n, File file) {
            super(1);
            this.bfd = n;
            this.file = file;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.inputFileOpen(jobBackendRef, this.bfd, this.file);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.bfd);
            objectOutput.writeObject(this.file);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.bfd = objectInput.readInt();
            this.file = (File)objectInput.readObject();
        }
    }

    private static class OutputFileCloseMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -5637017577338427153L;
        private int ffd;

        public OutputFileCloseMessage() {
        }

        public OutputFileCloseMessage(JobBackendRef jobBackendRef, int n) {
            super(1);
            this.ffd = n;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.outputFileClose(jobBackendRef, this.ffd);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.ffd = objectInput.readInt();
        }
    }

    private static class OutputFileFlushMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 7074849708663078210L;
        private int ffd;

        public OutputFileFlushMessage() {
        }

        public OutputFileFlushMessage(JobBackendRef jobBackendRef, int n) {
            super(1);
            this.ffd = n;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.outputFileFlush(jobBackendRef, this.ffd);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.ffd = objectInput.readInt();
        }
    }

    private static class OutputFileWriteMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -4460426636308841602L;
        private int ffd;
        private int len;

        public OutputFileWriteMessage() {
        }

        public OutputFileWriteMessage(JobBackendRef jobBackendRef, int n, int n2) {
            super(1);
            this.ffd = n;
            this.len = n2;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.outputFileWrite(jobBackendRef, this.ffd, null, 0, this.len);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.ffd);
            objectOutput.writeInt(this.len);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.ffd = objectInput.readInt();
            this.len = objectInput.readInt();
        }
    }

    private static class OutputFileOpenMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -4987754930269039852L;
        private int bfd;
        private File file;
        private boolean append;

        public OutputFileOpenMessage() {
        }

        public OutputFileOpenMessage(JobBackendRef jobBackendRef, int n, File file, boolean bl) {
            super(1);
            this.bfd = n;
            this.file = file;
            this.append = bl;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.outputFileOpen(jobBackendRef, this.bfd, this.file, this.append);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.bfd);
            objectOutput.writeBoolean(this.append);
            objectOutput.writeObject(this.file);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.bfd = objectInput.readInt();
            this.append = objectInput.readBoolean();
            this.file = (File)objectInput.readObject();
        }
    }

    private static class RequestResourceMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 9184806604713339263L;
        private String resourceName;

        public RequestResourceMessage() {
        }

        public RequestResourceMessage(JobBackendRef jobBackendRef, String string) {
            super(1);
            this.resourceName = string;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.requestResource(jobBackendRef, this.resourceName);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.resourceName);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.resourceName = objectInput.readUTF();
        }
    }

    private static class RenewLeaseMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -9030468939160436622L;

        public RenewLeaseMessage() {
        }

        public RenewLeaseMessage(JobSchedulerRef jobSchedulerRef) {
            super(4);
        }

        public RenewLeaseMessage(JobBackendRef jobBackendRef) {
            super(1);
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobSchedulerRef jobSchedulerRef) throws IOException {
            jobFrontendRef.renewLease(jobSchedulerRef);
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.renewLease(jobBackendRef);
        }
    }

    private static class CancelJobMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -2009079595329812496L;
        private String errmsg;

        public CancelJobMessage() {
        }

        public CancelJobMessage(JobSchedulerRef jobSchedulerRef, String string) {
            super(4);
            this.errmsg = string;
        }

        public CancelJobMessage(JobBackendRef jobBackendRef, String string) {
            super(1);
            this.errmsg = string;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobSchedulerRef jobSchedulerRef) throws IOException {
            jobFrontendRef.cancelJob(jobSchedulerRef, this.errmsg);
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.cancelJob(jobBackendRef, this.errmsg);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.errmsg);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.errmsg = objectInput.readUTF();
        }
    }

    private static class BackendReadyMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -8872540352133660209L;
        private int rank;
        private InetSocketAddress middlewareAddress;
        private InetSocketAddress worldAddress;
        private InetSocketAddress frontendAddress;

        public BackendReadyMessage() {
        }

        public BackendReadyMessage(JobBackendRef jobBackendRef, int n, InetSocketAddress inetSocketAddress, InetSocketAddress inetSocketAddress2, InetSocketAddress inetSocketAddress3) {
            super(1);
            this.rank = n;
            this.middlewareAddress = inetSocketAddress;
            this.worldAddress = inetSocketAddress2;
            this.frontendAddress = inetSocketAddress3;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.backendReady(jobBackendRef, this.rank, this.middlewareAddress, this.worldAddress, this.frontendAddress);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.rank);
            objectOutput.writeObject(this.middlewareAddress);
            objectOutput.writeObject(this.worldAddress);
            objectOutput.writeObject(this.frontendAddress);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.rank = objectInput.readInt();
            this.middlewareAddress = (InetSocketAddress)objectInput.readObject();
            this.worldAddress = (InetSocketAddress)objectInput.readObject();
            this.frontendAddress = (InetSocketAddress)objectInput.readObject();
        }
    }

    private static class BackendFinishedMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = 759872032212034107L;

        public BackendFinishedMessage() {
        }

        public BackendFinishedMessage(JobBackendRef jobBackendRef) {
            super(1);
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobBackendRef jobBackendRef) throws IOException {
            jobFrontendRef.backendFinished(jobBackendRef);
        }
    }

    private static class AssignJobNumberMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -197099388467750972L;
        private int jobnum;
        private String pjhost;

        public AssignJobNumberMessage() {
        }

        public AssignJobNumberMessage(JobSchedulerRef jobSchedulerRef, int n, String string) {
            super(4);
            this.jobnum = n;
            this.pjhost = string;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobSchedulerRef jobSchedulerRef) throws IOException {
            jobFrontendRef.assignJobNumber(jobSchedulerRef, this.jobnum, this.pjhost);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeInt(this.jobnum);
            objectOutput.writeUTF(this.pjhost);
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.jobnum = objectInput.readInt();
            this.pjhost = objectInput.readUTF();
        }
    }

    private static class AssignBackendMessage
    extends JobFrontendMessage {
        private static final long serialVersionUID = -5876685936167695648L;
        private String name;
        private String host;
        private String jvm;
        private String classpath;
        private String[] jvmflags;

        public AssignBackendMessage() {
        }

        public AssignBackendMessage(JobSchedulerRef jobSchedulerRef, String string, String string2, String string3, String string4, String[] stringArray) {
            super(4);
            this.name = string;
            this.host = string2;
            this.jvm = string3;
            this.classpath = string4;
            this.jvmflags = stringArray;
        }

        public void invoke(JobFrontendRef jobFrontendRef, JobSchedulerRef jobSchedulerRef) throws IOException {
            jobFrontendRef.assignBackend(jobSchedulerRef, this.name, this.host, this.jvm, this.classpath, this.jvmflags);
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            objectOutput.writeUTF(this.name);
            objectOutput.writeUTF(this.host);
            objectOutput.writeUTF(this.jvm);
            objectOutput.writeUTF(this.classpath);
            int n = this.jvmflags.length;
            objectOutput.writeInt(n);
            for (int i = 0; i < n; ++i) {
                objectOutput.writeUTF(this.jvmflags[i]);
            }
        }

        public void readExternal(ObjectInput objectInput) throws IOException {
            this.name = objectInput.readUTF();
            this.host = objectInput.readUTF();
            this.jvm = objectInput.readUTF();
            this.classpath = objectInput.readUTF();
            int n = objectInput.readInt();
            this.jvmflags = new String[n];
            for (int i = 0; i < n; ++i) {
                this.jvmflags[i] = objectInput.readUTF();
            }
        }
    }
}

