/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import java.util.ArrayList;

public class CommPattern {
    public final int sendTo;
    public final int recvFrom;

    private CommPattern(int n, int n2) {
        this.sendTo = n;
        this.recvFrom = n2;
    }

    public static int[] broadcastPattern(int n, int n2, int n3) {
        int n4;
        if (n < 1) {
            throw new IllegalArgumentException("broadcastPattern(): size must be >= 1");
        }
        if (0 > n2 || n2 >= n) {
            throw new IllegalArgumentException("broadcastPattern(): rank must be in the range 0 .. " + (n - 1));
        }
        if (0 > n3 || n3 >= n) {
            throw new IllegalArgumentException("broadcastPattern(): root must be in the range 0 .. " + (n - 1));
        }
        int n5 = n2 >= n3 ? n2 - n3 + 1 : n2 + n - n3 + 1;
        int n6 = -1;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 1; i < n; i <<= 1) {
            for (n4 = 1; n4 <= i; ++n4) {
                int n7 = n4 + i;
                if (n5 == n7) {
                    n6 = n4;
                    continue;
                }
                if (n5 != n4 || n7 > n) continue;
                arrayList.add(n7);
            }
        }
        n4 = arrayList.size();
        int[] nArray = new int[n4 + 1];
        nArray[0] = n6 == -1 ? -1 : (n6 + n3 - 1) % n;
        for (int i = 0; i < n4; ++i) {
            nArray[i + 1] = ((Integer)arrayList.get(i) + n3 - 1) % n;
        }
        return nArray;
    }

    public static CommPattern[] broadcastPatternRounds(int n, int n2, int n3) {
        if (n < 1) {
            throw new IllegalArgumentException("broadcastPatternRounds(): size must be >= 1");
        }
        if (0 > n2 || n2 >= n) {
            throw new IllegalArgumentException("broadcastPatternRounds(): rank must be in the range 0 .. " + (n - 1));
        }
        if (0 > n3 || n3 >= n) {
            throw new IllegalArgumentException("broadcastPatternRounds(): root must be in the range 0 .. " + (n - 1));
        }
        int n4 = n2 >= n3 ? n2 - n3 + 1 : n2 + n - n3 + 1;
        ArrayList<CommPattern> arrayList = new ArrayList<CommPattern>();
        for (int i = 1; i < n; i <<= 1) {
            int n5 = -1;
            int n6 = -1;
            for (int j = 1; j <= i; ++j) {
                int n7 = j + i;
                if (n4 == n7) {
                    n6 = j;
                    continue;
                }
                if (n4 != j || n7 > n) continue;
                n5 = n7;
            }
            if (n5 != -1) {
                n5 = (n5 + n3 - 1) % n;
            }
            if (n6 != -1) {
                n6 = (n6 + n3 - 1) % n;
            }
            arrayList.add(new CommPattern(n5, n6));
        }
        return arrayList.toArray(new CommPattern[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 2) {
            CommPattern.usage();
        }
        int n3 = Integer.parseInt(stringArray[0]);
        int n4 = Integer.parseInt(stringArray[1]);
        CommPattern[][] commPatternArrayArray = new CommPattern[n3][];
        for (n2 = 0; n2 < n3; ++n2) {
            commPatternArrayArray[n2] = CommPattern.broadcastPatternRounds(n3, n2, n4);
        }
        n2 = commPatternArrayArray[0].length;
        System.out.println("Size = " + n3 + ", root = " + n4);
        for (n = 0; n < n3; ++n) {
            if (n > 0) {
                System.out.print('\t');
            }
            System.out.print(n);
        }
        System.out.println();
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                if (i > 0) {
                    System.out.print('\t');
                }
                if (commPatternArrayArray[i][n].sendTo == -1) {
                    System.out.print('-');
                } else {
                    System.out.print('S');
                    System.out.print(commPatternArrayArray[i][n].sendTo);
                }
                System.out.print(',');
                if (commPatternArrayArray[i][n].recvFrom == -1) {
                    System.out.print('-');
                    continue;
                }
                System.out.print('R');
                System.out.print(commPatternArrayArray[i][n].recvFrom);
            }
            System.out.println();
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.pj.cluster.CommPattern <size> <root>");
        System.exit(1);
    }
}

