/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj.cluster;

import edu.rit.pj.cluster.JobBackendRef;
import edu.rit.pj.cluster.JobFrontendRef;
import edu.rit.pj.cluster.ResourceCache;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackendClassLoader
extends ClassLoader {
    private JobBackendRef myJobBackend;
    private JobFrontendRef myJobFrontend;
    private ResourceCache myCache;

    public BackendClassLoader(JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef, ResourceCache resourceCache) {
        this.myJobBackend = jobBackendRef;
        this.myJobFrontend = jobFrontendRef;
        this.myCache = resourceCache;
    }

    public BackendClassLoader(ClassLoader classLoader, JobBackendRef jobBackendRef, JobFrontendRef jobFrontendRef, ResourceCache resourceCache) {
        super(classLoader);
        this.myJobBackend = jobBackendRef;
        this.myJobFrontend = jobFrontendRef;
        this.myCache = resourceCache;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        try {
            byte[] byArray;
            String string2 = string.replace('.', '/') + ".class";
            if (!this.myCache.contains(string2)) {
                this.myJobFrontend.requestResource(this.myJobBackend, string2);
            }
            if ((byArray = this.myCache.get(string2)) == null) {
                throw new ClassNotFoundException("Class " + string + " not found");
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException("Class " + string + " not found due to I/O error", iOException);
        }
        catch (InterruptedException interruptedException) {
            throw new ClassNotFoundException("Class " + string + " not found because thread interrupted", interruptedException);
        }
    }
}

