/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.IntegerSchedule;
import edu.rit.pj.ItemGenerator;
import edu.rit.pj.LongSchedule;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.Spinner;
import java.io.PrintStream;
import java.util.concurrent.Semaphore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ParallelTeamThread
extends Thread {
    ParallelTeam myTeam;
    int myIndex;
    Semaphore myRegionBeginSemaphore = new Semaphore(0);
    volatile int myBarrierFlag;
    volatile int myConstructCount;
    volatile IntegerSchedule myIntegerSchedule;
    volatile LongSchedule myLongSchedule;
    volatile ItemGenerator<?> myItemGenerator;
    volatile Throwable myConstructException;
    private long pad01;
    private long pad02;
    private long pad03;
    private long pad04;
    private long pad05;
    private long pad06;
    private long pad07;
    private long pad08;

    public ParallelTeamThread(ParallelTeam parallelTeam, int n) {
        this.myTeam = parallelTeam;
        this.myIndex = n;
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            this.myRegionBeginSemaphore.acquireUninterruptibly();
            try {
                this.myTeam.myRegion.run();
            }
            catch (Throwable throwable) {
                PrintStream printStream = System.err;
                synchronized (printStream) {
                    System.err.println("Parallel team thread " + this.myIndex + ": ParallelRegion.run() threw an exception");
                    throwable.printStackTrace(System.err);
                }
                this.myTeam.myExceptionMap.put(this.myIndex, throwable);
            }
            this.myTeam.myRegionEndSemaphore.release();
        }
    }

    void barrier() {
        int n;
        this.myBarrierFlag = n = this.myTeam.myBarrierFlag ^ 1;
        if (this.myTeam.myBarrierFlag != n) {
            Spinner spinner = new Spinner();
            while (this.myTeam.myBarrierFlag != n) {
                spinner.spin();
            }
        }
    }

    void barrier(ParallelSection parallelSection) throws Exception {
        this.barrier();
    }

    boolean arriveAtParallelConstruct() {
        int n;
        int n2 = this.myTeam.K;
        for (n = 0; n < n2; ++n) {
            ParallelTeamThread parallelTeamThread = this.myTeam.myThread[n];
            if (parallelTeamThread.myConstructCount >= this.myConstructCount) continue;
            Spinner spinner = new Spinner();
            while (parallelTeamThread.myConstructCount < this.myConstructCount) {
                spinner.spin();
            }
        }
        do {
            if ((n = this.myTeam.myConstructCount.get()) == this.myConstructCount) continue;
            this.myConstructCount = n;
            return false;
        } while (!this.myTeam.myConstructCount.compareAndSet(n, n + 1));
        this.myConstructCount = n + 1;
        return true;
    }

    void setIntegerSchedule(IntegerSchedule integerSchedule) {
        if (this.myIntegerSchedule != null) {
            Spinner spinner = new Spinner();
            while (this.myIntegerSchedule != null) {
                spinner.spin();
            }
        }
        this.myIntegerSchedule = integerSchedule;
    }

    IntegerSchedule getIntegerSchedule() throws Exception {
        Object object;
        if (this.myIntegerSchedule == null && this.myConstructException == null) {
            object = new Spinner();
            while (this.myIntegerSchedule == null && this.myConstructException == null) {
                ((Spinner)object).spin();
            }
        }
        object = this.myIntegerSchedule;
        this.myIntegerSchedule = null;
        Throwable throwable = this.myConstructException;
        this.myConstructException = null;
        ParallelTeam.rethrow(throwable);
        return object;
    }

    void setLongSchedule(LongSchedule longSchedule) {
        if (this.myLongSchedule != null) {
            Spinner spinner = new Spinner();
            while (this.myLongSchedule != null) {
                spinner.spin();
            }
        }
        this.myLongSchedule = longSchedule;
    }

    LongSchedule getLongSchedule() throws Exception {
        Object object;
        if (this.myLongSchedule == null && this.myConstructException == null) {
            object = new Spinner();
            while (this.myLongSchedule == null && this.myConstructException == null) {
                ((Spinner)object).spin();
            }
        }
        object = this.myLongSchedule;
        this.myLongSchedule = null;
        Throwable throwable = this.myConstructException;
        this.myConstructException = null;
        ParallelTeam.rethrow(throwable);
        return object;
    }

    void setItemGenerator(ItemGenerator<?> itemGenerator) {
        if (this.myItemGenerator != null) {
            Spinner spinner = new Spinner();
            while (this.myItemGenerator != null) {
                spinner.spin();
            }
        }
        this.myItemGenerator = itemGenerator;
    }

    ItemGenerator<?> getItemGenerator() throws Exception {
        Object object;
        if (this.myItemGenerator == null && this.myConstructException == null) {
            object = new Spinner();
            while (this.myItemGenerator == null && this.myConstructException == null) {
                ((Spinner)object).spin();
            }
        }
        object = this.myItemGenerator;
        this.myItemGenerator = null;
        Throwable throwable = this.myConstructException;
        this.myConstructException = null;
        ParallelTeam.rethrow(throwable);
        return object;
    }

    void setConstructException(Throwable throwable) {
        if (this.myConstructException != null) {
            Spinner spinner = new Spinner();
            while (this.myConstructException != null) {
                spinner.spin();
            }
        }
        this.myConstructException = throwable;
    }
}

