/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.MultipleParallelException;
import edu.rit.pj.PJProperties;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeamThread;
import edu.rit.pj.ParallelTeamThread_0;
import edu.rit.pj.Spinner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;

public class ParallelTeam {
    int K;
    ParallelTeamThread[] myThread;
    ParallelRegion myRegion;
    Semaphore myRegionEndSemaphore = new Semaphore(0);
    ConcurrentHashMap<Integer, Throwable> myExceptionMap;
    volatile int myBarrierFlag;
    AtomicInteger myConstructCount = new AtomicInteger(0);

    public ParallelTeam() {
        this(ParallelTeam.getDefaultThreadCount());
    }

    public ParallelTeam(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("ParallelTeam(): K must be >= 1");
        }
        this.K = n;
        this.myThread = new ParallelTeamThread[n];
        this.myThread[0] = new ParallelTeamThread_0(this, 0);
        for (int i = 1; i < n; ++i) {
            this.myThread[i] = new ParallelTeamThread(this, i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ParallelRegion parallelRegion) throws Exception {
        if (parallelRegion == null) {
            throw new NullPointerException("ParallelTeam.execute(): theRegion is null");
        }
        if (this.myRegion != null) {
            throw new IllegalStateException("ParallelTeam.execute(): Already executing a parallel region");
        }
        if (parallelRegion.myTeam != null) {
            throw new IllegalStateException("ParallelTeam.execute(): theRegion already being executed by a parallel team");
        }
        this.myRegion = parallelRegion;
        this.myExceptionMap = new ConcurrentHashMap(this.K, 0.75f, this.K);
        parallelRegion.myTeam = this;
        try {
            this.myRegion.start();
            for (ParallelTeamThread parallelTeamThread : this.myThread) {
                parallelTeamThread.myRegionBeginSemaphore.release();
            }
            this.myRegionEndSemaphore.acquireUninterruptibly(this.K);
            if (!this.myExceptionMap.isEmpty()) {
                if (this.myExceptionMap.size() == 1) {
                    ParallelTeam.rethrow(this.myExceptionMap.values().iterator().next());
                } else {
                    throw new MultipleParallelException("ParallelTeam.execute(): Multiple threads threw exceptions", this.myExceptionMap);
                }
            }
            this.myRegion.finish();
        }
        finally {
            this.myRegion.myTeam = null;
            this.myExceptionMap = null;
            this.myRegion = null;
        }
    }

    public final boolean isExecutingInParallel() {
        return this.myRegion != null;
    }

    public final ParallelRegion region() {
        if (this.myRegion == null) {
            throw new IllegalStateException("ParallelTeam.region(): Not executing a parallel region");
        }
        return this.myRegion;
    }

    public final int getThreadCount() {
        return this.K;
    }

    public static int getDefaultThreadCount() {
        return PJProperties.getPjNt();
    }

    void barrier() {
        int n = this.myBarrierFlag ^ 1;
        for (int i = 1; i < this.K; ++i) {
            ParallelTeamThread parallelTeamThread = this.myThread[i];
            if (parallelTeamThread.myBarrierFlag == n) continue;
            Spinner spinner = new Spinner();
            while (parallelTeamThread.myBarrierFlag != n) {
                spinner.spin();
            }
        }
        this.myBarrierFlag = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void barrier(ParallelSection parallelSection) throws Exception {
        int n = this.myBarrierFlag ^ 1;
        for (int i = 1; i < this.K; ++i) {
            ParallelTeamThread parallelTeamThread = this.myThread[i];
            if (parallelTeamThread.myBarrierFlag == n) continue;
            Spinner spinner = new Spinner();
            while (parallelTeamThread.myBarrierFlag != n) {
                spinner.spin();
            }
        }
        try {
            parallelSection.myTeam = this;
            parallelSection.run();
        }
        finally {
            parallelSection.myTeam = null;
            this.myBarrierFlag = n;
        }
    }

    static void rethrow(Object object) throws Exception {
        if (object instanceof RuntimeException) {
            throw (RuntimeException)object;
        }
        if (object instanceof Exception) {
            throw (Exception)object;
        }
        if (object instanceof Error) {
            throw (Error)object;
        }
    }
}

