/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelTeam;
import edu.rit.pj.ParallelTeamThread;
import edu.rit.pj.Wait;

public abstract class ParallelConstruct {
    public static final Wait WAIT = Wait.WAIT;
    public static final Wait NO_WAIT = Wait.NO_WAIT;
    private long pad01;
    private long pad02;
    private long pad03;
    private long pad04;
    private long pad05;
    private long pad06;
    private long pad07;
    private long pad08;
    ParallelTeam myTeam;

    public final boolean isExecutingInParallel() {
        return this.myTeam != null;
    }

    public final ParallelTeam team() {
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelConstruct.team(): No parallel team executing");
        }
        return this.myTeam;
    }

    public final ParallelRegion region() {
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelConstruct.region(): No parallel team executing");
        }
        return this.myTeam.myRegion;
    }

    public final int getThreadCount() {
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelConstruct.getThreadCount(): No parallel team executing");
        }
        return this.myTeam.K;
    }

    public final int getThreadIndex() {
        return this.getCurrentThread().myIndex;
    }

    ParallelTeamThread getCurrentThread() {
        if (this.myTeam == null) {
            throw new IllegalStateException("ParallelConstruct.getCurrentThread(): No parallel team executing");
        }
        try {
            ParallelTeamThread parallelTeamThread = (ParallelTeamThread)Thread.currentThread();
            if (parallelTeamThread.myTeam != this.myTeam) {
                throw new IllegalStateException("ParallelConstruct.getCurrentThread(): Current thread is not executing this parallel construct");
            }
            return parallelTeamThread;
        }
        catch (ClassCastException classCastException) {
            throw new IllegalStateException("ParallelConstruct.getCurrentThread(): Current thread is not a parallel team thread", classCastException);
        }
    }
}

