/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

public class PJProperties {
    private PJProperties() {
    }

    public static int getPjNt() {
        try {
            int n;
            String string = System.getProperty("pj.nt");
            int n2 = n = string == null ? Runtime.getRuntime().availableProcessors() : Integer.parseInt(string);
            if (n < 1) {
                throw new IllegalArgumentException("pj.nt system property is not an integer >= 1");
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("pj.nt system property is not an integer >= 1");
        }
    }

    public static String getPjSchedule() {
        return System.getProperty("pj.schedule", "fixed");
    }

    public static int getPjNp() {
        try {
            int n;
            String string = System.getProperty("pj.np");
            int n2 = n = string == null ? 1 : Integer.parseInt(string);
            if (n < 1) {
                throw new IllegalArgumentException("pj.np system property is not an integer >= 1");
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("pj.np system property is not an integer >= 1");
        }
    }

    public static String getPjHost() {
        return System.getProperty("pj.host", "localhost");
    }

    public static int getPjPort() {
        try {
            String string = System.getProperty("pj.port");
            int n = string == null ? 20617 : Integer.parseInt(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("pj.port system property is not an integer");
        }
    }

    public static int getPjJobTime() {
        try {
            String string = System.getProperty("pj.jobtime");
            if (string == null) {
                return 0;
            }
            int n = Integer.parseInt(string);
            if (n < 1) {
                throw new IllegalArgumentException("pj.jobtime system property is not an integer >= 1");
            }
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("pj.jobtime system property is not an integer >= 1");
        }
    }

    public static String getPjJvmFlags() {
        return System.getProperty("pj.jvmflags", "");
    }

    public static String getPjPrng() {
        return System.getProperty("pj.prng", "edu.rit.util.DefaultRandom");
    }
}

