/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.DynamicLongSchedule;
import edu.rit.pj.FixedLongSchedule;
import edu.rit.pj.GuidedLongSchedule;
import edu.rit.pj.PJProperties;
import edu.rit.pj.Schedule;
import edu.rit.util.LongRange;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.atomic.AtomicLong;

public abstract class LongSchedule
extends Schedule {
    AtomicLong myOrderedIndex = new AtomicLong();

    protected LongSchedule() {
    }

    public static LongSchedule fixed() {
        return new FixedLongSchedule();
    }

    public static LongSchedule dynamic() {
        return new DynamicLongSchedule(1L);
    }

    public static LongSchedule dynamic(long l) {
        return new DynamicLongSchedule(l);
    }

    public static LongSchedule guided() {
        return new GuidedLongSchedule(1L);
    }

    public static LongSchedule guided(long l) {
        return new GuidedLongSchedule(l);
    }

    public static LongSchedule runtime() {
        return LongSchedule.parse(PJProperties.getPjSchedule());
    }

    public static LongSchedule parse(String string) {
        try {
            int n = string.indexOf(40);
            if (n == -1) {
                Class<?> clazz = Class.forName(LongSchedule.getSubclassName(string), true, Thread.currentThread().getContextClassLoader());
                return (LongSchedule)clazz.newInstance();
            }
            int n2 = string.indexOf(41);
            if (n2 != string.length() - 1) {
                throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal");
            }
            String[] stringArray = string.substring(n + 1, n2).split(",");
            Class<?> clazz = Class.forName(LongSchedule.getSubclassName(string.substring(0, n)), true, Thread.currentThread().getContextClassLoader());
            Constructor<?> constructor = clazz.getConstructor(String[].class);
            return (LongSchedule)constructor.newInstance(new Object[]{stringArray});
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal", classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal", classNotFoundException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal", illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal", instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal", invocationTargetException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalArgumentException("LongSchedule.parse(): Schedule \"" + string + "\" illegal", noSuchMethodException);
        }
    }

    private static String getSubclassName(String string) {
        if (string.equals("fixed")) {
            return "edu.rit.pj.FixedLongSchedule";
        }
        if (string.equals("dynamic")) {
            return "edu.rit.pj.DynamicLongSchedule";
        }
        if (string.equals("guided")) {
            return "edu.rit.pj.GuidedLongSchedule";
        }
        return string;
    }

    void commonStart(int n, LongRange longRange) {
        this.myBreak = false;
        this.myOrderedIndex.set(longRange.lb());
        this.start(n, longRange);
    }

    protected abstract void start(int var1, LongRange var2);

    LongRange commonNext(int n) {
        if (this.myBreak) {
            return null;
        }
        return this.next(n);
    }

    protected abstract LongRange next(int var1);
}

