/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.LongSchedule;
import edu.rit.util.LongRange;
import java.util.concurrent.atomic.AtomicLong;

class DynamicLongSchedule
extends LongSchedule {
    private LongRange myLoopRange;
    private AtomicLong N1 = new AtomicLong();
    private long N2;

    public DynamicLongSchedule() {
        this(1L);
    }

    public DynamicLongSchedule(long l) {
        if (l < 1L) {
            throw new IllegalArgumentException("DynamicLongSchedule(): Chunk size = " + l + " illegal");
        }
        this.N2 = l;
    }

    public DynamicLongSchedule(String[] stringArray) {
        this(DynamicLongSchedule.getChunkSize(stringArray));
    }

    private static long getChunkSize(String[] stringArray) {
        long l;
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("DynamicLongSchedule(): Usage: -Dpj.schedule=dynamic or -Dpj.schedule=\"dynamic(<n>)\"");
        }
        try {
            l = Long.parseLong(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("DynamicLongSchedule(): Chunk size = " + stringArray[0] + " illegal");
        }
        return l;
    }

    protected void start(int n, LongRange longRange) {
        this.myLoopRange = longRange;
        this.N1.set(0L);
    }

    protected LongRange next(int n) {
        LongRange longRange;
        long l;
        long l2;
        long l3;
        do {
            if ((l = (longRange = this.myLoopRange.chunk(l3 = this.N1.get(), this.N2)).length()) != 0L) continue;
            return null;
        } while (!this.N1.compareAndSet(l3, l2 = l3 + l));
        return longRange;
    }
}

