/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.pj.IntegerSchedule;
import edu.rit.util.Range;
import java.util.concurrent.atomic.AtomicInteger;

class DynamicIntegerSchedule
extends IntegerSchedule {
    private Range myLoopRange;
    private AtomicInteger N1 = new AtomicInteger();
    private int N2;

    public DynamicIntegerSchedule() {
        this(1);
    }

    public DynamicIntegerSchedule(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("DynamicIntegerSchedule(): Chunk size = " + n + " illegal");
        }
        this.N2 = n;
    }

    public DynamicIntegerSchedule(String[] stringArray) {
        this(DynamicIntegerSchedule.getChunkSize(stringArray));
    }

    private static int getChunkSize(String[] stringArray) {
        int n;
        if (stringArray.length != 1) {
            throw new IllegalArgumentException("DynamicIntegerSchedule(): Usage: -Dpj.schedule=dynamic or -Dpj.schedule=\"dynamic(<n>)\"");
        }
        try {
            n = Integer.parseInt(stringArray[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("DynamicIntegerSchedule(): Chunk size = " + stringArray[0] + " illegal");
        }
        return n;
    }

    protected void start(int n, Range range) {
        this.myLoopRange = range;
        this.N1.set(0);
    }

    protected Range next(int n) {
        Range range;
        int n2;
        int n3;
        int n4;
        do {
            if ((n2 = (range = this.myLoopRange.chunk(n4 = this.N1.get(), this.N2)).length()) != 0) continue;
            return null;
        } while (!this.N1.compareAndSet(n4, n3 = n4 + n2));
        return range;
    }
}

