/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.pj;

import edu.rit.mp.Buf;
import edu.rit.mp.Channel;
import edu.rit.mp.ChannelGroup;
import edu.rit.mp.IOCompletionHook;
import edu.rit.mp.IORequest;
import edu.rit.mp.ObjectBuf;
import edu.rit.mp.Status;
import edu.rit.pj.CommRequest;
import edu.rit.pj.CommStatus;
import edu.rit.pj.PJProperties;
import edu.rit.pj.cluster.CommPattern;
import edu.rit.pj.cluster.JobBackend;
import edu.rit.pj.cluster.JobFrontend;
import edu.rit.pj.cluster.JobSchedulerException;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.util.Range;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.HashMap;

public class Comm {
    private static Comm theWorldCommunicator;
    private static Comm theFrontendCommunicator;
    private int mySize;
    private int myRank;
    private String myHost;
    private ChannelGroup myChannelGroup;
    private InetSocketAddress[] myAddressForRank;
    private HashMap<InetAddress, Integer> myRankForHost = new HashMap();
    private Channel[] myChannelForRank;
    private int[][] myBroadcastTree;
    private AllGatherInfo[] myAllGatherInfo;

    private Comm(int n, int n2, String string, ChannelGroup channelGroup, InetSocketAddress[] inetSocketAddressArray) {
        this.mySize = n;
        this.myRank = n2;
        this.myHost = string;
        this.myChannelGroup = channelGroup;
        this.myAddressForRank = inetSocketAddressArray;
        for (int i = 0; i < n; ++i) {
            this.myRankForHost.put(inetSocketAddressArray[i].getAddress(), i);
        }
        this.myChannelForRank = new Channel[n];
        Channel channel = channelGroup.loopbackChannel();
        channel.info(new Integer(n2));
        this.myRankForHost.put(channel.farEndAddress().getAddress(), n2);
        this.myChannelForRank[n2] = channel;
    }

    public static void init(String[] stringArray) throws IOException {
        if (stringArray == null) {
            throw new NullPointerException("Comm.init(): args is null");
        }
        JobBackend jobBackend = JobBackend.getJobBackend();
        if (jobBackend == null) {
            String string = System.getProperty("user.name");
            int n = PJProperties.getPjNp();
            boolean bl = false;
            StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
            StackTraceElement stackTraceElement = stackTraceElementArray[stackTraceElementArray.length - 1];
            if (!stackTraceElement.getMethodName().equals("main")) {
                throw new IllegalStateException("Comm.init(): Not called from main program");
            }
            String string2 = stackTraceElement.getClassName();
            JobFrontend jobFrontend = null;
            try {
                jobFrontend = new JobFrontend(string, n, bl, string2, stringArray);
                jobFrontend.run();
                System.exit(0);
            }
            catch (JobSchedulerException jobSchedulerException) {
                System.err.println("No Job Scheduler at " + PJProperties.getPjHost() + ":" + PJProperties.getPjPort() + ", running in this (one) process");
                theWorldCommunicator = new Comm(1, 0, "<unknown>", new ChannelGroup(), new InetSocketAddress[]{new InetSocketAddress(0)});
            }
        } else {
            theWorldCommunicator = new Comm(jobBackend.getK(), jobBackend.getRank(), jobBackend.getBackendHost(), jobBackend.getWorldChannelGroup(), jobBackend.getWorldAddress());
        }
    }

    public static Comm world() {
        if (theWorldCommunicator != null) {
            return theWorldCommunicator;
        }
        if (JobBackend.getJobBackend() != null) {
            throw new IllegalStateException("Comm.world(): Didn't call Comm.init()");
        }
        throw new IllegalStateException("Comm.world(): World communicator doesn't exist in job frontend process");
    }

    public int size() {
        return this.mySize;
    }

    public int rank() {
        return this.myRank;
    }

    public String host() {
        return this.myHost;
    }

    public Comm createComm(boolean bl) throws IOException {
        return this.createComm(bl, 0);
    }

    public Comm createComm(boolean bl, int n) throws IOException {
        InetSocketAddress[] inetSocketAddressArray = new InetSocketAddress[this.mySize];
        Buf[] bufArray = ObjectBuf.sliceBuffers(inetSocketAddressArray, new Range(0, this.mySize - 1).subranges(this.mySize));
        ChannelGroup channelGroup = null;
        InetSocketAddress inetSocketAddress = null;
        if (bl) {
            channelGroup = new ChannelGroup(new InetSocketAddress(this.myChannelGroup.listenAddress().getAddress(), 0));
            inetSocketAddressArray[this.myRank] = inetSocketAddress = channelGroup.listenAddress();
        }
        this.allGather(n, bufArray[this.myRank], bufArray);
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        for (int i = 0; i < this.mySize; ++i) {
            if (inetSocketAddressArray[i] == null) {
                ++n2;
                continue;
            }
            if (i == this.myRank) {
                n4 = i - n2;
            }
            inetSocketAddressArray[i - n2] = inetSocketAddressArray[i];
            ++n3;
        }
        if (n3 == 0) {
            throw new IOException("Comm.createComm(): No processes in communicator");
        }
        if (bl) {
            return new Comm(n3, n4, this.myHost, channelGroup, inetSocketAddressArray);
        }
        return null;
    }

    public void send(int n, Buf buf) throws IOException {
        this.send(n, 0, buf);
    }

    public void send(int n, int n2, Buf buf) throws IOException {
        this.myChannelGroup.send(this.getChannel(n, true), n2, buf);
    }

    public CommRequest send(int n, Buf buf, CommRequest commRequest) throws IOException {
        return this.send(n, 0, buf, commRequest);
    }

    public CommRequest send(int n, int n2, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = this.myChannelGroup.sendNoWait(this.getChannel(n, true), n2, buf);
        commRequest2.myRecvRequest = null;
        return commRequest2;
    }

    public CommStatus receive(Integer n, Buf buf) throws IOException {
        return this.receive(n, 0, buf);
    }

    public CommStatus receive(Integer n, Integer n2, Buf buf) throws IOException {
        Status status = this.myChannelGroup.receive(n == null ? null : this.getChannel(n, false), n2, buf);
        return new CommStatus(this.getFarRank(status.channel), status.tag, status.length);
    }

    public CommRequest receive(Integer n, Buf buf, CommRequest commRequest) throws IOException {
        return this.receive(n, 0, buf, commRequest);
    }

    public CommRequest receive(Integer n, Integer n2, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = null;
        commRequest2.myRecvRequest = this.myChannelGroup.receiveNoWait(n == null ? null : this.getChannel(n, false), n2, buf);
        return commRequest2;
    }

    public CommStatus sendReceive(int n, Buf buf, int n2, Buf buf2) throws IOException {
        return this.sendReceive(n, 0, buf, n2, 0, buf2);
    }

    public CommStatus sendReceive(int n, int n2, Buf buf, int n3, int n4, Buf buf2) throws IOException {
        IORequest iORequest = this.myChannelGroup.sendNoWait(this.getChannel(n, n != n3 || this.myRank < n3), n2, buf);
        IORequest iORequest2 = this.myChannelGroup.receiveNoWait(this.getChannel(n3, false), n4, buf2);
        iORequest.waitForFinish();
        Status status = iORequest2.waitForFinish();
        return new CommStatus(this.getFarRank(status.channel), status.tag, status.length);
    }

    public CommRequest sendReceive(int n, Buf buf, int n2, Buf buf2, CommRequest commRequest) throws IOException {
        return this.sendReceive(n, 0, buf, n2, 0, buf2, commRequest);
    }

    public CommRequest sendReceive(int n, int n2, Buf buf, int n3, int n4, Buf buf2, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = this.myChannelGroup.sendNoWait(this.getChannel(n, n != n3 || this.myRank < n3), n2, buf);
        commRequest2.myRecvRequest = this.myChannelGroup.receiveNoWait(this.getChannel(n3, false), n4, buf2);
        return commRequest2;
    }

    public void floodSend(Buf buf) throws IOException {
        this.floodSend(0, buf, null).waitForFinish();
    }

    public void floodSend(int n, Buf buf) throws IOException {
        this.floodSend(n, buf, null).waitForFinish();
    }

    public CommRequest floodSend(Buf buf, CommRequest commRequest) throws IOException {
        return this.floodSend(0, buf, commRequest);
    }

    public CommRequest floodSend(int n, Buf buf, CommRequest commRequest) throws IOException {
        CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.myRecvRequest = null;
        commRequest2.mySendRequest = this.myChannelGroup.sendNoWait(this.getChannel(this.myRank, true), n, buf);
        return commRequest2;
    }

    public CommStatus floodReceive(Buf buf) throws IOException {
        return this.floodReceive(0, buf, null).waitForFinish();
    }

    public CommStatus floodReceive(Integer n, Buf buf) throws IOException {
        return this.floodReceive(n, buf, null).waitForFinish();
    }

    public CommRequest floodReceive(Buf buf, CommRequest commRequest) throws IOException {
        return this.floodReceive(0, buf, commRequest);
    }

    public CommRequest floodReceive(Integer n, final Buf buf, CommRequest commRequest) throws IOException {
        final CommRequest commRequest2 = commRequest == null ? new CommRequest() : commRequest;
        commRequest2.mySendRequest = null;
        commRequest2.myRecvRequest = this.myChannelGroup.receiveNoWait(null, n, buf, new IOCompletionHook(){

            public void finished(IORequest iORequest, Status status) throws IOException {
                int n = Comm.this.getFarRank(status.channel);
                int n2 = status.tag;
                IORequest iORequest2 = commRequest2.myRecvRequest;
                IORequest iORequest3 = null;
                for (int n3 : Comm.this.getBroadcastTree(0)) {
                    if (n3 < 0 || n3 == n) continue;
                    iORequest3 = Comm.this.myChannelGroup.sendNoWait(Comm.this.getChannel(n3, true), n2, buf);
                    iORequest2.chain(iORequest3);
                    iORequest2 = iORequest3;
                }
            }
        });
        return commRequest2;
    }

    public void broadcast(int n, Buf buf) throws IOException {
        this.broadcast(n, 0, buf);
    }

    public void broadcast(int n, int n2, Buf buf) throws IOException {
        int n3;
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.broadcast(): root = " + n + " out of bounds");
        }
        int[] nArray = this.getBroadcastTree(n);
        int n4 = nArray.length;
        int n5 = nArray[0];
        if (n5 != -1) {
            this.myChannelGroup.receive(this.getChannel(n5, false), n2, buf);
        }
        IORequest[] iORequestArray = new IORequest[n4];
        for (n3 = 1; n3 < n4; ++n3) {
            int n6 = nArray[n3];
            iORequestArray[n3] = this.myChannelGroup.sendNoWait(this.getChannel(n6, true), n2, buf);
        }
        for (n3 = 1; n3 < n4; ++n3) {
            iORequestArray[n3].waitForFinish();
        }
    }

    public void scatter(int n, Buf[] bufArray, Buf buf) throws IOException {
        this.scatter(n, 0, bufArray, buf);
    }

    public void scatter(int n, int n2, Buf[] bufArray, Buf buf) throws IOException {
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.scatter(): root = " + n + " out of bounds");
        }
        if (this.myRank == n) {
            int n3;
            IORequest[] iORequestArray = new IORequest[this.mySize];
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3] = this.myChannelGroup.sendNoWait(this.getChannel(n3, true), n2, bufArray[n3]);
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3] = this.myChannelGroup.sendNoWait(this.getChannel(n3, true), n2, bufArray[n3]);
            }
            buf.copy(bufArray[this.myRank]);
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
        } else {
            this.myChannelGroup.receive(this.getChannel(n, false), n2, buf);
        }
    }

    public void gather(int n, Buf buf, Buf[] bufArray) throws IOException {
        this.gather(n, 0, buf, bufArray);
    }

    public void gather(int n, int n2, Buf buf, Buf[] bufArray) throws IOException {
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.gather(): root = " + n + " out of bounds");
        }
        if (this.myRank == n) {
            int n3;
            IORequest[] iORequestArray = new IORequest[this.mySize];
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3] = this.myChannelGroup.receiveNoWait(this.getChannel(n3, false), n2, bufArray[n3]);
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3] = this.myChannelGroup.receiveNoWait(this.getChannel(n3, false), n2, bufArray[n3]);
            }
            bufArray[this.myRank].copy(buf);
            for (n3 = 0; n3 < this.myRank; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
            for (n3 = this.myRank + 1; n3 < this.mySize; ++n3) {
                iORequestArray[n3].waitForFinish();
            }
        } else {
            this.myChannelGroup.send(this.getChannel(n, true), n2, buf);
        }
    }

    public void allGather(Buf buf, Buf[] bufArray) throws IOException {
        this.allGather(0, buf, bufArray);
    }

    public void allGather(int n, Buf buf, Buf[] bufArray) throws IOException {
        if (this.myAllGatherInfo == null) {
            int n2;
            CommPattern[][] commPatternArrayArray = new CommPattern[this.mySize][];
            for (n2 = 0; n2 < this.mySize; ++n2) {
                commPatternArrayArray[n2] = CommPattern.broadcastPatternRounds(this.mySize, this.myRank, n2);
            }
            int n3 = commPatternArrayArray[0].length;
            this.myAllGatherInfo = new AllGatherInfo[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                AllGatherInfo allGatherInfo;
                this.myAllGatherInfo[n2] = allGatherInfo = new AllGatherInfo();
                allGatherInfo.sendTo = -1;
                allGatherInfo.recvFrom = -1;
                int n4 = 0;
                int n5 = 0;
                allGatherInfo.sendBufIndex = new int[this.mySize];
                allGatherInfo.recvBufIndex = new int[this.mySize];
                for (int i = 0; i < this.mySize; ++i) {
                    if (commPatternArrayArray[i][n2].sendTo != -1) {
                        allGatherInfo.sendTo = commPatternArrayArray[i][n2].sendTo;
                        allGatherInfo.sendBufIndex[n4++] = i;
                    }
                    if (commPatternArrayArray[i][n2].recvFrom == -1) continue;
                    allGatherInfo.recvFrom = commPatternArrayArray[i][n2].recvFrom;
                    allGatherInfo.recvBufIndex[n5++] = i;
                }
                allGatherInfo.bufCount = n4;
            }
        }
        bufArray[this.myRank].copy(buf);
        for (AllGatherInfo allGatherInfo : this.myAllGatherInfo) {
            for (int i = 0; i < allGatherInfo.bufCount; ++i) {
                this.sendReceive(allGatherInfo.sendTo, n, bufArray[allGatherInfo.sendBufIndex[i]], allGatherInfo.recvFrom, n, bufArray[allGatherInfo.recvBufIndex[i]]);
            }
        }
    }

    public void reduce(int n, Buf buf, Op op) throws IOException {
        this.reduce(n, 0, buf, buf, op);
    }

    public void reduce(int n, int n2, Buf buf, Op op) throws IOException {
        this.reduce(n, n2, buf, buf, op);
    }

    public void reduce(int n, Buf buf, Buf buf2, Op op) throws IOException {
        this.reduce(n, 0, buf, buf2, op);
    }

    public void reduce(int n, int n2, Buf buf, Buf buf2, Op op) throws IOException {
        int n3;
        if (0 > n || n >= this.mySize) {
            throw new IndexOutOfBoundsException("Comm.reduce(): root = " + n + " out of bounds");
        }
        int[] nArray = this.getBroadcastTree(n);
        int n4 = nArray.length;
        buf2.copy(buf);
        Buf buf3 = buf2.getReductionBuf(op);
        for (n3 = n4 - 1; n3 >= 1; --n3) {
            int n5 = nArray[n3];
            this.myChannelGroup.receive(this.getChannel(n5, false), n2, buf3);
        }
        n3 = nArray[0];
        if (n3 != -1) {
            this.myChannelGroup.send(this.getChannel(n3, true), n2, buf2);
        }
    }

    public void allReduce(Buf buf, Op op) throws IOException {
        this.allReduce(0, buf, buf, op);
    }

    public void allReduce(int n, Buf buf, Op op) throws IOException {
        this.allReduce(n, buf, buf, op);
    }

    public void allReduce(Buf buf, Buf buf2, Op op) throws IOException {
        this.reduce(0, buf, buf2, op);
    }

    public void allReduce(int n, Buf buf, Buf buf2, Op op) throws IOException {
        this.reduce(0, n, buf, buf2, op);
        this.broadcast(0, n, buf2);
    }

    public void barrier() throws IOException {
        this.barrier(0);
    }

    public void barrier(int n) throws IOException {
        this.allReduce(n, Buf.emptyBuffer(), (Op)IntegerOp.SUM);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Comm(size=");
        stringBuilder.append(this.mySize);
        stringBuilder.append(",rank=");
        stringBuilder.append(this.myRank);
        stringBuilder.append(",backend");
        for (int i = 0; i < this.mySize; ++i) {
            if (i > 0) {
                stringBuilder.append(',');
            }
            stringBuilder.append('[');
            stringBuilder.append(i);
            stringBuilder.append("]=");
            stringBuilder.append(this.myAddressForRank[i]);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    private synchronized Channel getChannel(int n, boolean bl) throws IOException {
        Channel channel = this.myChannelForRank[n];
        if (channel == null) {
            InetSocketAddress inetSocketAddress = this.myAddressForRank[n];
            if (bl) {
                channel = this.myChannelGroup.connect(inetSocketAddress);
            } else {
                try {
                    channel = this.myChannelGroup.waitForChannelToHost(inetSocketAddress.getAddress());
                }
                catch (InterruptedException interruptedException) {
                    InterruptedIOException interruptedIOException = new InterruptedIOException();
                    interruptedIOException.initCause(interruptedException);
                    throw interruptedIOException;
                }
            }
            channel.info(new Integer(n));
            this.myChannelForRank[n] = channel;
        }
        return channel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getFarRank(Channel channel) {
        int n;
        Integer n2 = (Integer)channel.info();
        if (n2 == null) {
            n2 = this.myRankForHost.get(channel.farEndAddress().getAddress());
            n = n2;
            Comm comm = this;
            synchronized (comm) {
                channel.info(n2);
                this.myChannelForRank[n] = channel;
            }
        } else {
            n = n2;
        }
        return n;
    }

    private int[] getBroadcastTree(int n) {
        int[] nArray;
        if (this.myBroadcastTree == null) {
            this.myBroadcastTree = new int[this.mySize][];
        }
        if ((nArray = this.myBroadcastTree[n]) == null) {
            nArray = CommPattern.broadcastPattern(this.mySize, this.myRank, n);
            this.myBroadcastTree[n] = nArray;
        }
        return nArray;
    }

    private static class AllGatherInfo {
        public int sendTo;
        public int recvFrom;
        public int bufCount;
        public int[] sendBufIndex;
        public int[] recvBufIndex;

        private AllGatherInfo() {
        }
    }
}

