/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars.test;

import edu.rit.phyl.pars.DnaSequence;
import edu.rit.phyl.pars.DnaSequenceTree;

public class Test03 {
    static int N;
    static DnaSequenceTree[] treestack;
    static final DnaSequenceTree.Stringifier stringifier;
    static final char[] v2c;

    private Test03() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 1) {
            Test03.usage();
        }
        N = Integer.parseInt(stringArray[0]);
        treestack = new DnaSequenceTree[N];
        for (int i = 0; i < N; ++i) {
            Test03.treestack[i] = new DnaSequenceTree(N);
        }
        DnaSequenceTree.defaultStringifier(stringifier);
        treestack[0].addTipNode(0, new DnaSequence(0, 0));
        Test03.generateTrees(0);
    }

    private static void generateTrees(int n) {
        DnaSequenceTree dnaSequenceTree = treestack[n];
        if (dnaSequenceTree.isFull()) {
            System.out.println(dnaSequenceTree);
        } else {
            DnaSequenceTree dnaSequenceTree2 = treestack[n + 1];
            int n2 = dnaSequenceTree.nodeCount();
            for (int i = 0; i < n2; ++i) {
                dnaSequenceTree2.copy(dnaSequenceTree);
                dnaSequenceTree2.addTipNode(i, new DnaSequence(0, n + 1));
                Test03.generateTrees(n + 1);
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.phyl.pars.test.Test03 <N>");
        System.err.println("<N> = Number of tip nodes");
        System.exit(1);
    }

    static {
        stringifier = new DnaSequenceTree.Stringifier(){

            public String toString(DnaSequenceTree.Node node) {
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = node.sequence().score() + 1; i > 0; i /= 27) {
                    stringBuilder.insert(0, v2c[i % 27]);
                }
                return stringBuilder.toString();
            }
        };
        v2c = new char[]{' ', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    }
}

