/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars;

import edu.rit.phyl.pars.DnaSequence;
import edu.rit.phyl.pars.DnaSequenceList;
import edu.rit.phyl.pars.DnaSequenceTree;
import edu.rit.phyl.pars.DnaSequenceTreeList;
import edu.rit.pj.Comm;
import edu.rit.pj.ParallelRegion;
import edu.rit.pj.ParallelSection;
import edu.rit.pj.ParallelTeam;
import java.io.File;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class MaxParsSmp {
    static final int DEFAULT_DEPTH = 7;
    static DnaSequenceList sequences;
    static int S;
    static int D;
    static DnaSequenceList excised;
    static int uninformativeStateChanges;
    static AtomicInteger bestScore;
    static AtomicLong searchNodeID;
    static DnaSequenceTree.Stringifier stringifier;

    private MaxParsSmp() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        long l = -System.currentTimeMillis();
        if (stringArray.length < 1 || stringArray.length > 3) {
            MaxParsSmp.usage();
        }
        File file = new File(stringArray[0]);
        S = stringArray.length < 2 ? 0 : Integer.parseInt(stringArray[1]);
        D = stringArray.length < 3 ? 7 : Integer.parseInt(stringArray[2]);
        System.out.println("Reading input file ...");
        sequences = DnaSequenceList.read(file);
        if (S > 0) {
            sequences.truncate(S);
        }
        S = sequences.length();
        System.out.println(S + " sequences");
        for (n = 0; n < S; ++n) {
            System.out.println("\t" + sequences.getName(n));
        }
        System.out.println(sequences.getDnaSequence(0).length() + " sites");
        sequences.warnOfDuplicates();
        System.out.println("Excising uninformative sites ...");
        excised = new DnaSequenceList();
        uninformativeStateChanges = sequences.exciseUninformativeSites(excised);
        System.out.println(excised.getDnaSequence(0).length() + " informative sites");
        System.out.println(uninformativeStateChanges + " state changes from uninformative sites");
        excised.warnOfDuplicates();
        System.out.println("Shuffling into descending distance order ...");
        excised.shuffleDescendingDistance();
        for (n = 0; n < S; ++n) {
            System.out.println("\t" + excised.getName(n));
        }
        DnaSequenceTree.defaultStringifier(stringifier);
        n = S > D ? ParallelTeam.getDefaultThreadCount() : 1;
        new ParallelTeam(n).execute(new ParallelRegion(){

            public void run() throws Exception {
                DnaSequenceTree[] dnaSequenceTreeArray = new DnaSequenceTree[S];
                for (int i = 0; i < S; ++i) {
                    dnaSequenceTreeArray[i] = new DnaSequenceTree(S);
                }
                final DnaSequenceTreeList dnaSequenceTreeList = new DnaSequenceTreeList(S);
                dnaSequenceTreeArray[0].addTipNode(0, excised.getDnaSequence(0));
                MaxParsSmp.generateTrees(dnaSequenceTreeArray, dnaSequenceTreeList, 0, 0L);
                this.barrier();
                dnaSequenceTreeList.bestScore(bestScore.get());
                this.critical(new ParallelSection(){

                    public void run() {
                        for (DnaSequenceTree dnaSequenceTree : dnaSequenceTreeList) {
                            System.out.println(dnaSequenceTree);
                        }
                    }
                });
            }
        });
        System.out.println((l += System.currentTimeMillis()) + " msec");
        System.out.println(bestScore + " state changes in best tree(s)");
    }

    private static void generateTrees(DnaSequenceTree[] dnaSequenceTreeArray, DnaSequenceTreeList dnaSequenceTreeList, int n, long l) {
        DnaSequenceTree dnaSequenceTree = dnaSequenceTreeArray[n];
        int n2 = n + 1;
        if (n2 == S) {
            dnaSequenceTreeList.bestScore(bestScore.get());
            int n3 = dnaSequenceTreeList.bestScore();
            dnaSequenceTreeArray[n] = dnaSequenceTreeList.add(dnaSequenceTree);
            int n4 = dnaSequenceTreeList.bestScore();
            if (n3 != n4) {
                MaxParsSmp.bestScoreMinimum(n4);
            }
        } else if (n2 != D || MaxParsSmp.firstToReachID(l)) {
            DnaSequence dnaSequence = excised.getDnaSequence(n2);
            int n5 = dnaSequenceTree.nodeCount();
            l *= (long)n5;
            for (int i = 0; i < n5; ++i) {
                DnaSequenceTree dnaSequenceTree2 = dnaSequenceTreeArray[n2];
                dnaSequenceTree2.copy(dnaSequenceTree);
                dnaSequenceTree2.updateFitchScore(dnaSequenceTree2.addTipNode(i, dnaSequence));
                if (dnaSequenceTree2.score() > bestScore.get()) continue;
                MaxParsSmp.generateTrees(dnaSequenceTreeArray, dnaSequenceTreeList, n2, l + (long)i);
            }
        }
    }

    private static void bestScoreMinimum(int n) {
        int n2;
        int n3;
        while (!bestScore.compareAndSet(n3 = bestScore.get(), n2 = Math.min(n3, n))) {
        }
    }

    private static boolean firstToReachID(long l) {
        long l2;
        long l3 = l + 1L;
        do {
            if ((l2 = searchNodeID.get()) <= l) continue;
            return false;
        } while (!searchNodeID.compareAndSet(l2, l3));
        return true;
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.phyl.pars.MaxParsSmp <infile> [<S>]");
        System.err.println("<infile> = DNA sequence file in interleaved PHYLIP format");
        System.err.println("<S> = Number of DNA sequences to consider (default: all)");
        System.exit(1);
    }

    static {
        bestScore = new AtomicInteger(Integer.MAX_VALUE);
        searchNodeID = new AtomicLong(0L);
        stringifier = new DnaSequenceTree.Stringifier(){

            public String toString(DnaSequenceTree.Node node) {
                return sequences.getName(node.sequence().score());
            }
        };
    }
}

