/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars;

import edu.rit.phyl.pars.DnaSequence;
import edu.rit.phyl.pars.DnaSequenceList;
import edu.rit.phyl.pars.DnaSequenceTree;
import edu.rit.phyl.pars.DnaSequenceTreeList;
import edu.rit.pj.Comm;
import java.io.File;

public class MaxParsExh {
    static DnaSequenceList sequences;
    static int S;
    static DnaSequenceList excised;
    static int uninformativeStateChanges;
    static DnaSequenceTree[] treeStack;
    static DnaSequenceTreeList bestTreeList;
    static DnaSequenceTree.Stringifier stringifier;

    private MaxParsExh() {
    }

    public static void main(String[] stringArray) throws Exception {
        int n;
        Comm.init(stringArray);
        long l = -System.currentTimeMillis();
        if (stringArray.length < 1 || stringArray.length > 2) {
            MaxParsExh.usage();
        }
        File file = new File(stringArray[0]);
        S = stringArray.length < 2 ? 0 : Integer.parseInt(stringArray[1]);
        System.out.println("Reading input file ...");
        sequences = DnaSequenceList.read(file);
        if (S > 0) {
            sequences.truncate(S);
        }
        S = sequences.length();
        System.out.println(S + " sequences");
        for (n = 0; n < S; ++n) {
            System.out.println("\t" + sequences.getName(n));
        }
        System.out.println(sequences.getDnaSequence(0).length() + " sites");
        sequences.warnOfDuplicates();
        System.out.println("Excising uninformative sites ...");
        excised = new DnaSequenceList();
        uninformativeStateChanges = sequences.exciseUninformativeSites(excised);
        System.out.println(excised.getDnaSequence(0).length() + " informative sites");
        System.out.println(uninformativeStateChanges + " state changes from uninformative sites");
        excised.warnOfDuplicates();
        treeStack = new DnaSequenceTree[S];
        for (n = 0; n < S; ++n) {
            MaxParsExh.treeStack[n] = new DnaSequenceTree(S);
        }
        bestTreeList = new DnaSequenceTreeList(S);
        DnaSequenceTree.defaultStringifier(stringifier);
        treeStack[0].addTipNode(0, excised.getDnaSequence(0));
        MaxParsExh.generateTrees(0);
        System.out.println((l += System.currentTimeMillis()) + " msec");
        System.out.println(bestTreeList.bestScore() + " state changes in best tree(s)");
        for (DnaSequenceTree dnaSequenceTree : bestTreeList) {
            System.out.println(dnaSequenceTree);
        }
    }

    private static void generateTrees(int n) {
        DnaSequenceTree dnaSequenceTree = treeStack[n];
        int n2 = n + 1;
        if (n2 == S) {
            MaxParsExh.treeStack[n] = bestTreeList.add(dnaSequenceTree);
        } else {
            DnaSequence dnaSequence = excised.getDnaSequence(n2);
            int n3 = dnaSequenceTree.nodeCount();
            for (int i = 0; i < n3; ++i) {
                DnaSequenceTree dnaSequenceTree2 = treeStack[n2];
                dnaSequenceTree2.copy(dnaSequenceTree);
                dnaSequenceTree2.updateFitchScore(dnaSequenceTree2.addTipNode(i, dnaSequence));
                MaxParsExh.generateTrees(n2);
            }
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.phyl.pars.MaxParsExh <infile> [<S>]");
        System.err.println("<infile> = DNA sequence file in interleaved PHYLIP format");
        System.err.println("<S> = Number of DNA sequences to consider (default: all)");
        System.exit(1);
    }

    static {
        stringifier = new DnaSequenceTree.Stringifier(){

            public String toString(DnaSequenceTree.Node node) {
                return sequences.getName(node.sequence().score());
            }
        };
    }
}

