/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars;

import edu.rit.phyl.pars.DnaSequenceTree;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DnaSequenceTreeList
implements Iterable<DnaSequenceTree> {
    private static final int ALLOC = 20;
    private DnaSequenceTree[] myElement = new DnaSequenceTree[0];
    private int mySize = 0;
    private int myBestScore = Integer.MAX_VALUE;
    private int myTreeCapacity;

    public DnaSequenceTreeList(int n) {
        if (n < 1) {
            throw new NegativeArraySizeException("DnaSequenceTreeList(): N = " + n + " illegal");
        }
        this.myTreeCapacity = n;
    }

    public boolean isEmpty() {
        return this.mySize == 0;
    }

    public int size() {
        return this.mySize;
    }

    public void clear() {
        this.mySize = 0;
        this.myBestScore = Integer.MAX_VALUE;
    }

    public int bestScore() {
        return this.myBestScore;
    }

    public void bestScore(int n) {
        if (n < this.myBestScore) {
            this.mySize = 0;
            this.myBestScore = n;
        }
    }

    public DnaSequenceTree add(DnaSequenceTree dnaSequenceTree) {
        int n = dnaSequenceTree.score();
        if (n > this.myBestScore) {
            return dnaSequenceTree;
        }
        this.bestScore(n);
        this.ensureAllocation(1);
        DnaSequenceTree dnaSequenceTree2 = this.myElement[this.mySize];
        this.myElement[this.mySize] = dnaSequenceTree;
        ++this.mySize;
        return dnaSequenceTree2;
    }

    @Override
    public Iterator<DnaSequenceTree> iterator() {
        return new Iterator<DnaSequenceTree>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < DnaSequenceTreeList.this.mySize;
            }

            @Override
            public DnaSequenceTree next() {
                if (this.i >= DnaSequenceTreeList.this.mySize) {
                    throw new NoSuchElementException();
                }
                return DnaSequenceTreeList.this.myElement[this.i++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private void ensureAllocation(int n) {
        int n2 = this.myElement.length;
        if (this.mySize + n > n2) {
            DnaSequenceTree[] dnaSequenceTreeArray = new DnaSequenceTree[n2 += Math.max(n, 20)];
            System.arraycopy(this.myElement, 0, dnaSequenceTreeArray, 0, this.mySize);
            for (int i = this.mySize; i < n2; ++i) {
                dnaSequenceTreeArray[i] = new DnaSequenceTree(this.myTreeCapacity);
            }
            this.myElement = dnaSequenceTreeArray;
        }
    }
}

