/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars;

import edu.rit.phyl.pars.DnaSequence;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class DnaSequenceTree
implements Externalizable {
    private static final long serialVersionUID = -1405663180316351649L;
    int myTipCapacity;
    int myNodeCapacity;
    int myTipCount;
    int myNodeCount;
    Node[] myNode;
    int myRoot;
    int myScore;
    private transient long pad01;
    private transient long pad02;
    private transient long pad03;
    private transient long pad04;
    private transient long pad05;
    private transient long pad06;
    private transient long pad07;
    private transient long pad08;
    static Stringifier theDefaultStringifier = new Stringifier(){

        public String toString(Node node) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(node.mySequence);
            stringBuilder.append(':');
            stringBuilder.append(((Node)node).mySequence.myScore);
            return stringBuilder.toString();
        }
    };

    public DnaSequenceTree() {
        this(1);
    }

    public DnaSequenceTree(int n) {
        this.allocate(n);
    }

    private void allocate(int n) {
        this.myTipCapacity = n;
        this.myNodeCapacity = 2 * n - 1;
        this.myTipCount = 0;
        this.myNodeCount = 0;
        this.myNode = new Node[this.myNodeCapacity];
        for (int i = 0; i < this.myNodeCapacity; ++i) {
            this.myNode[i] = new Node();
        }
        this.myRoot = -1;
        this.myScore = 0;
    }

    public DnaSequenceTree(DnaSequenceTree dnaSequenceTree) {
        this.allocate(dnaSequenceTree.myTipCapacity);
        this.copy(dnaSequenceTree);
    }

    public int tipCapacity() {
        return this.myTipCapacity;
    }

    public int nodeCapacity() {
        return this.myNodeCapacity;
    }

    public int tipCount() {
        return this.myTipCount;
    }

    public int nodeCount() {
        return this.myNodeCount;
    }

    public boolean isEmpty() {
        return this.myTipCount == 0;
    }

    public boolean isFull() {
        return this.myTipCount == this.myTipCapacity;
    }

    public Node root() {
        return this.myRoot == -1 ? null : this.myNode[this.myRoot];
    }

    public int score() {
        return this.myScore;
    }

    public void score(int n) {
        this.myScore = n;
    }

    public void clear() {
        this.myTipCount = 0;
        this.myNodeCount = 0;
        this.myRoot = -1;
        this.myScore = 0;
    }

    public void copy(DnaSequenceTree dnaSequenceTree) {
        if (this.myTipCapacity != dnaSequenceTree.myTipCapacity) {
            this.allocate(dnaSequenceTree.myTipCapacity);
        }
        this.myTipCount = dnaSequenceTree.myTipCount;
        this.myNodeCount = dnaSequenceTree.myNodeCount;
        for (int i = 0; i < this.myNodeCount; ++i) {
            this.myNode[i].copy(dnaSequenceTree.myNode[i]);
        }
        this.myRoot = dnaSequenceTree.myRoot;
        this.myScore = dnaSequenceTree.myScore;
    }

    public Node addTipNode(int n, DnaSequence dnaSequence) {
        Node node;
        if (this.myTipCount == 0) {
            node = this.myNode[0];
            node.mySequence.copy(dnaSequence);
            node.myParent = -1;
            node.myChild1 = -1;
            node.myChild2 = -1;
            this.myRoot = 0;
            this.myTipCount = 1;
            this.myNodeCount = 1;
        } else {
            if (this.myTipCount == this.myTipCapacity) {
                throw new IllegalStateException("DnaSequenceTree.addTipNode(): tree full");
            }
            if (0 > n || n >= this.myNodeCount) {
                throw new IndexOutOfBoundsException("DnaSequenceTree.addTipNode(): index = " + n + " out of bounds");
            }
            int n2 = this.myNodeCount;
            int n3 = this.myNodeCount + 1;
            node = this.myNode[n2];
            Node node2 = this.myNode[n3];
            Node node3 = this.myNode[n];
            node.mySequence.copy(dnaSequence);
            node.myParent = n3;
            node.myChild1 = -1;
            node.myChild2 = -1;
            node2.myParent = node3.myParent;
            node2.myChild1 = n;
            node2.myChild2 = n2;
            node3.myParent = n3;
            if (node2.myParent == -1) {
                this.myRoot = n3;
            } else {
                Node node4 = this.myNode[node2.myParent];
                if (node4.myChild1 == n) {
                    node4.myChild1 = n3;
                } else {
                    node4.myChild2 = n3;
                }
            }
            ++this.myTipCount;
            this.myNodeCount += 2;
        }
        return node;
    }

    public void updateFitchScore(Node node) {
        Node node2 = node.parent();
        if (node2 != null) {
            node2.mySequence.setFitchAncestor(node2.child1().mySequence, node2.child2().mySequence);
            this.myScore += ((Node)node2).mySequence.myScore;
            node2 = node2.parent();
        }
        while (node2 != null) {
            int n = ((Node)node2).mySequence.myScore;
            node2.mySequence.setFitchAncestor(node2.child1().mySequence, node2.child2().mySequence);
            int n2 = ((Node)node2).mySequence.myScore;
            this.myScore = this.myScore - n + n2;
            node2 = node2.parent();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.myTipCapacity);
        objectOutput.writeInt(this.myTipCount);
        for (int i = 0; i < this.myNodeCount; ++i) {
            this.myNode[i].writeExternal(objectOutput);
        }
        objectOutput.writeInt(this.myRoot);
        objectOutput.writeInt(this.myScore);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (this.myTipCapacity != n) {
            this.allocate(n);
        }
        this.myTipCount = objectInput.readInt();
        this.myNodeCount = 2 * this.myTipCount - 1;
        for (int i = 0; i < this.myNodeCount; ++i) {
            this.myNode[i].readExternal(objectInput);
        }
        this.myRoot = objectInput.readInt();
        this.myScore = objectInput.readInt();
    }

    public String toString() {
        return this.toString(theDefaultStringifier);
    }

    public String toString(Stringifier stringifier) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.myTipCount == 0) {
            stringBuilder.append('(');
            stringBuilder.append(')');
        } else if (this.myTipCount == 1) {
            stringBuilder.append('(');
            stringBuilder.append(stringifier.toString(this.myNode[0]));
            stringBuilder.append(')');
        } else {
            this.toString(stringifier, stringBuilder, this.myRoot);
        }
        return stringBuilder.toString();
    }

    private void toString(Stringifier stringifier, StringBuilder stringBuilder, int n) {
        Node node = this.myNode[n];
        if (node.myChild1 == -1) {
            stringBuilder.append(stringifier.toString(node));
        } else {
            stringBuilder.append('(');
            this.toString(stringifier, stringBuilder, node.myChild1);
            stringBuilder.append(',');
            this.toString(stringifier, stringBuilder, node.myChild2);
            stringBuilder.append(')');
        }
    }

    public static Stringifier defaultStringifier() {
        return theDefaultStringifier;
    }

    public static void defaultStringifier(Stringifier stringifier) {
        if (stringifier == null) {
            throw new NullPointerException("DnaSequenceTree.defaultStringifier(): stringifier is null");
        }
        theDefaultStringifier = stringifier;
    }

    public void dump() {
        System.out.print("DNA sequence tree, myTipCapacity=");
        System.out.print(this.myTipCapacity);
        System.out.print(", myNodeCapacity=");
        System.out.print(this.myNodeCapacity);
        System.out.print(", myTipCount=");
        System.out.print(this.myTipCount);
        System.out.print(", myNodeCount=");
        System.out.print(this.myNodeCount);
        System.out.print(", myRoot=");
        System.out.print(this.myRoot);
        System.out.print(", myScore=");
        System.out.print(this.myScore);
        System.out.println();
        if (this.root() != null) {
            this.dumpnode(this.root(), 1);
        }
    }

    private void dumpnode(Node node, int n) {
        for (int i = 0; i < n; ++i) {
            System.out.print(".\t");
        }
        System.out.print(((Node)node).mySequence.myScore);
        System.out.print(' ');
        System.out.print(node.mySequence);
        System.out.println();
        if (node.child1() != null) {
            this.dumpnode(node.child1(), n + 1);
        }
        if (node.child2() != null) {
            this.dumpnode(node.child2(), n + 1);
        }
    }

    public static interface Stringifier {
        public String toString(Node var1);
    }

    public class Node
    implements Externalizable {
        private static final long serialVersionUID = 8525724559158098803L;
        private DnaSequence mySequence = new DnaSequence();
        private int myParent = -1;
        private int myChild1 = -1;
        private int myChild2 = -1;
        private transient long pad01;
        private transient long pad02;
        private transient long pad03;
        private transient long pad04;
        private transient long pad05;
        private transient long pad06;
        private transient long pad07;
        private transient long pad08;

        private Node() {
        }

        private Node(Node node) {
            this.copy(node);
        }

        private void copy(Node node) {
            this.mySequence.copy(node.mySequence);
            this.myParent = node.myParent;
            this.myChild1 = node.myChild1;
            this.myChild2 = node.myChild2;
        }

        public DnaSequence sequence() {
            return this.mySequence;
        }

        public Node parent() {
            return this.myParent == -1 ? null : DnaSequenceTree.this.myNode[this.myParent];
        }

        public Node child1() {
            return this.myChild1 == -1 ? null : DnaSequenceTree.this.myNode[this.myChild1];
        }

        public Node child2() {
            return this.myChild2 == -1 ? null : DnaSequenceTree.this.myNode[this.myChild2];
        }

        public void writeExternal(ObjectOutput objectOutput) throws IOException {
            this.mySequence.writeExternal(objectOutput);
            objectOutput.writeInt(this.myParent);
            objectOutput.writeInt(this.myChild1);
            objectOutput.writeInt(this.myChild2);
        }

        public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
            this.mySequence.readExternal(objectInput);
            this.myParent = objectInput.readInt();
            this.myChild1 = objectInput.readInt();
            this.myChild2 = objectInput.readInt();
        }
    }
}

