/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars;

import edu.rit.phyl.pars.DnaSequence;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Scanner;

public class DnaSequenceList {
    DnaSequence[] mySequence;
    String[] myName;
    private static String[] padding = new String[]{"          ", "         ", "        ", "       ", "      ", "     ", "    ", "   ", "  ", " "};

    public DnaSequenceList() {
        this(0);
    }

    public DnaSequenceList(int n) {
        this.mySequence = new DnaSequence[n];
        this.myName = new String[n];
    }

    public int length() {
        return this.mySequence.length;
    }

    public DnaSequence getDnaSequence(int n) {
        return this.mySequence[n];
    }

    public void setDnaSequence(int n, DnaSequence dnaSequence) {
        this.mySequence[n] = dnaSequence;
    }

    public String getName(int n) {
        return this.myName[n];
    }

    public void setName(int n, String string) {
        this.myName[n] = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DnaSequenceList read(File file) throws IOException {
        Scanner scanner = new Scanner(file);
        try {
            int n;
            if (!scanner.hasNextLine()) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Empty file");
            }
            Scanner scanner2 = new Scanner(scanner.nextLine());
            if (!scanner2.hasNextInt()) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of species invalid or missing");
            }
            int n2 = scanner2.nextInt();
            if (n2 < 2) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of species must be >= 2");
            }
            if (!scanner2.hasNextInt()) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of sites invalid or missing");
            }
            int n3 = scanner2.nextInt();
            if (n3 < 1) {
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Number of sites must be >= 1");
            }
            DnaSequenceList dnaSequenceList = new DnaSequenceList(n2);
            int[] nArray = new int[n2];
            block22: while (true) {
                n = 0;
                while (true) {
                    if (n >= n2) continue block22;
                    if (!scanner.hasNextLine()) {
                        if (n == 0 && nArray[n] != 0) break block22;
                        throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Missing a line of sequence data for species " + (n + 1));
                    }
                    String string = scanner.nextLine();
                    if (string.trim().equals("")) {
                        --n;
                    } else {
                        if (nArray[n] == 0) {
                            if (string.length() < 10) {
                                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Name must be 10 characters for species " + (n + 1));
                            }
                            dnaSequenceList.mySequence[n] = new DnaSequence(n3, n);
                            dnaSequenceList.myName[n] = string.substring(0, 10).trim();
                            string = string.substring(10);
                        }
                        int n4 = string.length();
                        byte[] byArray = dnaSequenceList.mySequence[n].mySites;
                        byte[] byArray2 = dnaSequenceList.mySequence[0].mySites;
                        int n5 = nArray[n];
                        block24: for (int i = 0; i < n4; ++i) {
                            switch (string.charAt(i)) {
                                case '-': 
                                case 'O': 
                                case 'o': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 0;
                                    ++n5;
                                    continue block24;
                                }
                                case 'A': 
                                case 'a': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 1;
                                    ++n5;
                                    continue block24;
                                }
                                case 'C': 
                                case 'c': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 2;
                                    ++n5;
                                    continue block24;
                                }
                                case 'M': 
                                case 'm': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 3;
                                    ++n5;
                                    continue block24;
                                }
                                case 'G': 
                                case 'g': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 4;
                                    ++n5;
                                    continue block24;
                                }
                                case 'R': 
                                case 'r': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 5;
                                    ++n5;
                                    continue block24;
                                }
                                case 'S': 
                                case 's': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 6;
                                    ++n5;
                                    continue block24;
                                }
                                case 'V': 
                                case 'v': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 7;
                                    ++n5;
                                    continue block24;
                                }
                                case 'T': 
                                case 't': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 8;
                                    ++n5;
                                    continue block24;
                                }
                                case 'W': 
                                case 'w': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 9;
                                    ++n5;
                                    continue block24;
                                }
                                case 'Y': 
                                case 'y': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 10;
                                    ++n5;
                                    continue block24;
                                }
                                case 'H': 
                                case 'h': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 11;
                                    ++n5;
                                    continue block24;
                                }
                                case 'K': 
                                case 'k': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 12;
                                    ++n5;
                                    continue block24;
                                }
                                case 'D': 
                                case 'd': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 13;
                                    ++n5;
                                    continue block24;
                                }
                                case 'B': 
                                case 'b': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 14;
                                    ++n5;
                                    continue block24;
                                }
                                case '?': 
                                case 'N': 
                                case 'X': 
                                case 'n': 
                                case 'x': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    byArray[n5] = 15;
                                    ++n5;
                                    continue block24;
                                }
                                case '.': {
                                    DnaSequenceList.verifyCount(n5, n3, file, n);
                                    if (n == 0) {
                                        throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "'.' not allowed in species 1");
                                    }
                                    if (n5 >= nArray[0]) {
                                        throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "'.' in species " + (n + 1) + " has no corresponding site in species 1");
                                    }
                                    byArray[n5] = byArray2[n5];
                                    ++n5;
                                }
                            }
                        }
                        nArray[n] = n5;
                    }
                    ++n;
                }
                break;
            }
            for (n = 0; n < n2; ++n) {
                if (nArray[n] < n3) {
                    throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Too few sites for species " + (n + 1));
                }
                if (nArray[n] <= n3) continue;
                throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Too many sites for species " + (n + 1));
            }
            DnaSequenceList dnaSequenceList2 = dnaSequenceList;
            return dnaSequenceList2;
        }
        finally {
            scanner.close();
        }
    }

    private static void verifyCount(int n, int n2, File file, int n3) throws IOException {
        if (n >= n2) {
            throw new IOException("DnaSequenceList.read(\"" + file + "\"): " + "Too many sites for species " + (n3 + 1));
        }
    }

    public void write(File file) throws IOException {
        this.write(file, 70, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(File file, int n, boolean bl) throws IOException {
        if (n <= 10) {
            throw new IllegalArgumentException("DnaSequenceList.write(): sites = " + n + " illegal");
        }
        PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
        try {
            int n2 = this.mySequence.length;
            int n3 = this.mySequence[0].length();
            printStream.print(n2);
            printStream.print(' ');
            printStream.print(n3);
            printStream.println();
            int n4 = 0;
            int n5 = Math.min(n - 10, n3);
            byte[] byArray = this.mySequence[0].mySites;
            while (n4 < n3) {
                for (int i = 0; i < n2; ++i) {
                    byte[] byArray2 = this.mySequence[i].mySites;
                    if (n4 == 0) {
                        printStream.print(DnaSequenceList.padName(this.myName[i]));
                    }
                    for (int j = n4; j < n5; ++j) {
                        if ((n4 == 0 || j > n4) && j % 10 == 0) {
                            printStream.print(' ');
                        }
                        if (bl && i > 0 && byArray2[j] == byArray[j]) {
                            printStream.print('.');
                            continue;
                        }
                        printStream.print(DnaSequence.state2char[byArray2[j]]);
                    }
                    printStream.println();
                }
                printStream.println();
                n4 = n5;
                n5 = Math.min(n5 + n, n3);
            }
            if (printStream.checkError()) {
                throw new IOException("DnaSequenceList.write(\"" + file + "\"): I/O error");
            }
        }
        finally {
            printStream.close();
        }
    }

    private static String padName(String string) {
        if (string == null) {
            return padding[0];
        }
        int n = string.length();
        if (n == 10) {
            return string;
        }
        if (n > 10) {
            return string.substring(0, 10);
        }
        return string + padding[n];
    }

    public void truncate(int n) {
        if (n < this.mySequence.length) {
            DnaSequence[] dnaSequenceArray = new DnaSequence[n];
            System.arraycopy(this.mySequence, 0, dnaSequenceArray, 0, n);
            this.mySequence = dnaSequenceArray;
        }
    }

    public void warnOfDuplicates() {
        int n = this.mySequence.length;
        for (int i = 0; i < n - 1; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (!this.mySequence[i].equals(this.mySequence[j])) continue;
                System.out.println("WARNING: Sequence \"" + this.myName[i] + "\" and sequence \"" + this.myName[j] + "\" are identical");
            }
        }
    }

    public int exciseUninformativeSites(DnaSequenceList dnaSequenceList) {
        int n;
        int n2 = this.mySequence.length;
        int n3 = this.mySequence[0].length();
        boolean[] blArray = new boolean[n3];
        int n4 = 0;
        int n5 = 0;
        int[] nArray = new int[16];
        for (n = 0; n < n3; ++n) {
            int n6;
            int n7;
            Arrays.fill(nArray, 0);
            for (n7 = 0; n7 < n2; ++n7) {
                byte by = this.mySequence[n7].mySites[n];
                nArray[by] = nArray[by] + 1;
            }
            n7 = 0;
            for (n6 = 0; n6 < 16; ++n6) {
                if (nArray[n6] < 2) continue;
                ++n7;
            }
            if (n7 >= 2) {
                blArray[n] = true;
                ++n4;
                continue;
            }
            blArray[n] = false;
            for (n6 = 0; n6 < 16; ++n6) {
                if (nArray[n6] <= 0) continue;
                ++n5;
            }
            --n5;
        }
        dnaSequenceList.mySequence = new DnaSequence[n2];
        for (n = 0; n < n2; ++n) {
            dnaSequenceList.mySequence[n] = new DnaSequence(n4, this.mySequence[n].myScore);
        }
        for (n = 0; n < n2; ++n) {
            byte[] byArray = dnaSequenceList.mySequence[n].mySites;
            byte[] byArray2 = this.mySequence[n].mySites;
            int n8 = 0;
            for (int i = 0; i < n3; ++i) {
                if (!blArray[i]) continue;
                byArray[n8++] = byArray2[i];
            }
        }
        dnaSequenceList.myName = new String[n2];
        System.arraycopy(this.myName, 0, dnaSequenceList.myName, 0, n2);
        return n5;
    }

    public void shuffleDescendingDistance() {
        int n;
        int n2 = this.mySequence.length;
        if (n2 <= 2) {
            return;
        }
        int n3 = -1;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                n5 += this.distance(i, n);
            }
            if (n5 <= n3) continue;
            n3 = n5;
            n4 = i;
        }
        DnaSequence dnaSequence = this.mySequence[0];
        this.mySequence[0] = this.mySequence[n4];
        this.mySequence[n4] = dnaSequence;
        String string = this.myName[0];
        this.myName[0] = this.myName[n4];
        this.myName[n4] = string;
        for (n = 1; n < n2; ++n) {
            n3 = -1;
            n4 = -1;
            for (int i = n; i < n2; ++i) {
                int n6 = this.distance(0, i);
                if (n6 <= n3) continue;
                n3 = n6;
                n4 = i;
            }
            dnaSequence = this.mySequence[n];
            this.mySequence[n] = this.mySequence[n4];
            this.mySequence[n4] = dnaSequence;
            string = this.myName[n];
            this.myName[n] = this.myName[n4];
            this.myName[n4] = string;
        }
    }

    public void shuffleAscendingDistance() {
        int n;
        int n2 = this.mySequence.length;
        if (n2 <= 2) {
            return;
        }
        int n3 = Integer.MAX_VALUE;
        int n4 = -1;
        for (int i = 0; i < n2; ++i) {
            int n5 = 0;
            for (n = 0; n < n2; ++n) {
                n5 += this.distance(i, n);
            }
            if (n5 >= n3) continue;
            n3 = n5;
            n4 = i;
        }
        DnaSequence dnaSequence = this.mySequence[0];
        this.mySequence[0] = this.mySequence[n4];
        this.mySequence[n4] = dnaSequence;
        String string = this.myName[0];
        this.myName[0] = this.myName[n4];
        this.myName[n4] = string;
        for (n = 1; n < n2; ++n) {
            n3 = Integer.MAX_VALUE;
            n4 = -1;
            for (int i = n; i < n2; ++i) {
                int n6 = this.distance(0, i);
                if (n6 >= n3) continue;
                n3 = n6;
                n4 = i;
            }
            dnaSequence = this.mySequence[n];
            this.mySequence[n] = this.mySequence[n4];
            this.mySequence[n4] = dnaSequence;
            string = this.myName[n];
            this.myName[n] = this.myName[n4];
            this.myName[n4] = string;
        }
    }

    private int distance(int n, int n2) {
        int n3 = this.mySequence[n].length();
        byte[] byArray = this.mySequence[n].mySites;
        byte[] byArray2 = this.mySequence[n2].mySites;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            ++n4;
        }
        return n4;
    }
}

