/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl.pars;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;

public class DnaSequence
implements Externalizable {
    private static final long serialVersionUID = 711922997806967374L;
    private static final int PAD = 64;
    static final char[] state2char = new char[]{'-', 'A', 'C', 'M', 'G', 'R', 'S', 'V', 'T', 'W', 'Y', 'H', 'K', 'D', 'B', 'X'};
    byte[] mySites;
    int myScore;
    private transient long pad01;
    private transient long pad02;
    private transient long pad03;
    private transient long pad04;
    private transient long pad05;
    private transient long pad06;
    private transient long pad07;
    private transient long pad08;

    public DnaSequence() {
        this(0);
    }

    public DnaSequence(int n) {
        this(n, 0);
    }

    public DnaSequence(int n, int n2) {
        this.mySites = new byte[n + 64];
        this.myScore = n2;
    }

    public DnaSequence(DnaSequence dnaSequence) {
        this.copy(dnaSequence);
    }

    public int length() {
        return this.mySites.length - 64;
    }

    public int score() {
        return this.myScore;
    }

    public void score(int n) {
        this.myScore = n;
    }

    public void copy(DnaSequence dnaSequence) {
        this.mySites = dnaSequence.mySites;
        this.myScore = dnaSequence.myScore;
    }

    public void setFitchAncestor(DnaSequence dnaSequence, DnaSequence dnaSequence2) {
        byte[] byArray = dnaSequence.mySites;
        byte[] byArray2 = dnaSequence2.mySites;
        int n = byArray.length - 64;
        byte[] byArray3 = new byte[n + 64];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            byte by2 = byArray2[i];
            int n3 = by & by2;
            if (n3 == 0) {
                n3 = by | by2;
                ++n2;
            }
            byArray3[i] = (byte)n3;
        }
        this.mySites = byArray3;
        this.myScore = n2;
    }

    public boolean equals(Object object) {
        return object instanceof DnaSequence && Arrays.equals(this.mySites, ((DnaSequence)object).mySites);
    }

    public int hashCode() {
        return Arrays.hashCode(this.mySites);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.mySites.length - 64;
        for (int i = 0; i < n; ++i) {
            if (i > 0 && i % 10 == 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(state2char[this.mySites[i]]);
        }
        return stringBuilder.toString();
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.mySites.length - 64;
        objectOutput.writeInt(n);
        objectOutput.write(this.mySites, 0, n);
        objectOutput.writeInt(this.myScore);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        this.mySites = new byte[n + 64];
        objectInput.readFully(this.mySites, 0, n);
        this.myScore = objectInput.readInt();
    }
}

