/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.phyl;

import edu.rit.draw.Drawing;
import edu.rit.draw.item.Line;
import edu.rit.draw.item.Point;
import edu.rit.draw.item.Text;
import java.io.File;
import java.util.LinkedList;

public class DrawTree {
    static final double V = 15.0;
    static final double H = 36.0;
    static final double GAP = 6.0;
    static String treestring;
    static char[] tree;
    static int index;
    static int tipCount;

    private DrawTree() {
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            DrawTree.usage();
        }
        treestring = stringArray[0];
        tree = stringArray[0].toCharArray();
        File file = new File(stringArray[1]);
        Point point = DrawTree.parseNode();
        if (index != tree.length) {
            DrawTree.syntaxError("Extra characters");
        }
        new Line().to(point).hby(-36.0).add();
        Drawing.write(file);
    }

    private static Point parseNode() {
        if (DrawTree.currentChar() != '(') {
            DrawTree.syntaxError("( expected");
        }
        ++index;
        Point point = DrawTree.parseChildList();
        if (DrawTree.currentChar() != ')') {
            DrawTree.syntaxError(") expected");
        }
        ++index;
        return point;
    }

    private static Point parseChildList() {
        LinkedList<Point> linkedList = new LinkedList<Point>();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        while (true) {
            Point point = DrawTree.parseChild();
            linkedList.add(point);
            d = Math.min(d, point.x());
            if (DrawTree.currentChar() != ',') break;
            ++index;
        }
        d -= 36.0;
        for (Point point : linkedList) {
            new Line().to(point).hto(d).add();
        }
        d2 = ((Point)linkedList.get(0)).y();
        d3 = ((Point)linkedList.get(linkedList.size() - 1)).y();
        new Line().to(d, d2).to(d, d3).add();
        return new Point(d, (d2 + d3) / 2.0);
    }

    private static Point parseChild() {
        if (DrawTree.currentChar() == '(') {
            return DrawTree.parseNode();
        }
        return DrawTree.parseTip();
    }

    private static Point parseTip() {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        while ((c = DrawTree.currentChar()) != '(' && c != ')' && c != ',') {
            stringBuilder.append(c);
            ++index;
        }
        Point point = new Point(0.0, (double)tipCount * 15.0);
        ++tipCount;
        String string = stringBuilder.toString();
        if (string.length() > 0) {
            new Text().text(string).w(point.e(6.0)).add();
        }
        return point;
    }

    private static char currentChar() {
        if (index >= tree.length) {
            DrawTree.syntaxError("Incomplete tree");
        }
        return tree[index];
    }

    private static void syntaxError(String string) {
        System.err.println("Syntax error: " + string);
        System.err.println(treestring);
        for (int i = 0; i < index; ++i) {
            System.err.print(' ');
        }
        System.err.println('^');
        System.exit(1);
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.phyl.DrawTree \"<tree>\" <file>");
        System.err.println("<tree> = Tree in Newick Standard format");
        System.err.println("<file> = Drawing file name");
        System.exit(1);
    }

    static {
        index = 0;
        tipCount = 0;
    }
}

