/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.CurveSmoothing;
import edu.rit.numeric.plot.impl.Grid;
import edu.rit.numeric.plot.impl.Label;
import edu.rit.numeric.plot.impl.NumericalAxis;
import edu.rit.numeric.plot.impl.PlotSeries;
import edu.rit.swing.Displayable;
import edu.rit.swing.Drawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;

public class XYPlot
implements Displayable {
    public static final double DEFAULT_MARGIN = 54.0;
    public static final Paint DEFAULT_BACKGROUND = Color.white;
    protected NumericalAxis myXAxis;
    protected NumericalAxis myYAxis;
    protected Grid myGrid;
    protected ArrayList<PlotSeries> myPlotSeries = new ArrayList();
    protected ArrayList<Label> myLabels = new ArrayList();
    protected double myLeftMargin;
    protected double myTopMargin;
    protected double myRightMargin;
    protected double myBottomMargin;
    protected double myWidth;
    protected double myHeight;
    protected Rectangle2D.Double myBoundingBox;
    protected Paint myBackgroundPaint;

    public XYPlot(NumericalAxis numericalAxis, NumericalAxis numericalAxis2) {
        this(numericalAxis, numericalAxis2, null, 54.0, 54.0, 54.0, 54.0, DEFAULT_BACKGROUND);
    }

    public XYPlot(NumericalAxis numericalAxis, NumericalAxis numericalAxis2, Grid grid) {
        this(numericalAxis, numericalAxis2, grid, 54.0, 54.0, 54.0, 54.0, DEFAULT_BACKGROUND);
    }

    public XYPlot(NumericalAxis numericalAxis, NumericalAxis numericalAxis2, Grid grid, double d) {
        this(numericalAxis, numericalAxis2, grid, d, d, d, d, DEFAULT_BACKGROUND);
    }

    public XYPlot(NumericalAxis numericalAxis, NumericalAxis numericalAxis2, Grid grid, double d, double d2, double d3, double d4) {
        this(numericalAxis, numericalAxis2, grid, d, d2, d3, d4, DEFAULT_BACKGROUND);
    }

    public XYPlot(NumericalAxis numericalAxis, NumericalAxis numericalAxis2, Grid grid, double d, double d2, double d3, double d4, Paint paint) {
        if (numericalAxis == null || numericalAxis2 == null || paint == null) {
            throw new NullPointerException();
        }
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myXAxis = numericalAxis;
        this.myYAxis = numericalAxis2;
        this.myGrid = grid;
        this.myLeftMargin = d;
        this.myTopMargin = d2;
        this.myRightMargin = d3;
        this.myBottomMargin = d4;
        this.myWidth = this.myLeftMargin + this.myXAxis.getLength() + this.myRightMargin;
        this.myHeight = this.myTopMargin + this.myYAxis.getLength() + this.myBottomMargin;
        this.myBoundingBox = new Rectangle2D.Double(0.0, 0.0, this.myWidth, this.myHeight);
        this.myBackgroundPaint = paint;
    }

    public void addPlotSeries(PlotSeries plotSeries) {
        if (plotSeries == null) {
            throw new NullPointerException();
        }
        this.myPlotSeries.add(plotSeries);
    }

    public void addLabel(Label label) {
        if (label == null) {
            throw new NullPointerException();
        }
        this.myLabels.add(label);
    }

    public void draw(Graphics2D graphics2D) {
        double d;
        double d2;
        AffineTransform affineTransform = graphics2D.getTransform();
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        Shape shape = graphics2D.getClip();
        double d3 = this.myLeftMargin;
        double d4 = this.myHeight - this.myBottomMargin;
        double d5 = this.myWidth - this.myLeftMargin - this.myRightMargin;
        double d6 = this.myHeight - this.myTopMargin - this.myBottomMargin;
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.myLeftMargin - 3.0, this.myTopMargin - 3.0, d5 + 6.0, d6 + 6.0);
        if (this.myGrid != null) {
            graphics2D.translate(d3, d4);
            this.myGrid.drawHorizontalGridlines(graphics2D, this.myYAxis, d5);
            this.myGrid.drawVerticalGridlines(graphics2D, this.myXAxis, d6);
            graphics2D.setTransform(affineTransform);
        }
        double d7 = this.myYAxis.getDisplayDistance(this.myYAxis.getCrossing());
        graphics2D.translate(d3, d4 - d7);
        this.myXAxis.drawHorizontal(graphics2D);
        graphics2D.setTransform(affineTransform);
        double d8 = this.myXAxis.getDisplayDistance(this.myXAxis.getCrossing());
        graphics2D.translate(d3 + d8, d4);
        this.myYAxis.drawVertical(graphics2D);
        graphics2D.setTransform(affineTransform);
        for (PlotSeries object : this.myPlotSeries) {
            double d9;
            double d10;
            int n;
            int n2;
            Drawable drawable = object.getDots();
            Stroke stroke2 = object.getStroke();
            Paint paint2 = object.getPaint();
            if (stroke2 != null && paint2 != null) {
                graphics2D.clip(double_);
                graphics2D.translate(d3, d4);
                graphics2D.setStroke(stroke2);
                graphics2D.setPaint(paint2);
                n2 = object.getLineCount();
                double[] dArray = new double[n2];
                double[] dArray2 = new double[n2];
                double[] dArray3 = new double[n2];
                double[] dArray4 = new double[n2];
                for (n = 0; n < n2; ++n) {
                    d10 = object.getLineX1(n);
                    d9 = object.getLineY1(n);
                    double d11 = object.getLineX2(n);
                    double d12 = object.getLineY2(n);
                    dArray[n] = this.myXAxis.getDisplayDistance(d10);
                    dArray2[n] = -this.myYAxis.getDisplayDistance(d9);
                    dArray3[n] = this.myXAxis.getDisplayDistance(d11);
                    dArray4[n] = -this.myYAxis.getDisplayDistance(d12);
                }
                graphics2D.draw(object.isSmooth() ? XYPlot.getCurvedPath(dArray, dArray2, dArray3, dArray4, n2) : XYPlot.getStraightPath(dArray, dArray2, dArray3, dArray4, n2));
                graphics2D.setTransform(affineTransform);
                graphics2D.setClip(shape);
            }
            if (drawable == null) continue;
            n2 = object.getDotCount();
            for (n = 0; n < n2; ++n) {
                d10 = object.getDotX(n);
                d9 = object.getDotY(n);
                if (!this.myXAxis.includesValue(d10) || !this.myYAxis.includesValue(d9)) continue;
                d2 = this.myXAxis.getDisplayDistance(d10);
                d = this.myYAxis.getDisplayDistance(d9);
                graphics2D.translate(d3 + d2, d4 - d);
                drawable.draw(graphics2D);
                graphics2D.setTransform(affineTransform);
            }
        }
        for (Label label : this.myLabels) {
            if (label.getPositioning() / 36 == 1) {
                d2 = label.getLocationX();
                d = label.getLocationY();
            } else {
                d2 = this.myXAxis.getDisplayDistance(label.getLocationX());
                d = this.myYAxis.getDisplayDistance(label.getLocationY());
            }
            graphics2D.translate(d3 + d2, d4 - d);
            label.draw(graphics2D);
            graphics2D.setTransform(affineTransform);
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    private static GeneralPath getStraightPath(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n) {
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)dArray[0], (float)dArray2[0]);
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)dArray3[i], (float)dArray4[i]);
            if (i >= n - 1 || dArray3[i] == dArray[i + 1] && dArray4[i] == dArray2[i + 1]) continue;
            generalPath.moveTo((float)dArray[i + 1], (float)dArray2[i + 1]);
        }
        return generalPath;
    }

    private static GeneralPath getCurvedPath(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, int n) {
        GeneralPath generalPath = new GeneralPath();
        double[] dArray5 = new double[n + 1];
        double[] dArray6 = new double[n + 1];
        double[] dArray7 = new double[n + 1];
        double[] dArray8 = new double[n + 1];
        double[] dArray9 = new double[n + 1];
        double[] dArray10 = new double[n + 1];
        int n2 = 0;
        while (n2 < n) {
            int n3;
            dArray5[n2] = dArray[n2];
            dArray8[n2] = dArray2[n2];
            for (n3 = n2 + 1; n3 < n && dArray3[n3 - 1] == dArray[n3] && dArray4[n3 - 1] == dArray2[n3]; ++n3) {
                dArray5[n3] = dArray[n3];
                dArray8[n3] = dArray2[n3];
            }
            dArray5[n3] = dArray3[n3 - 1];
            dArray8[n3] = dArray4[n3 - 1];
            int n4 = n3 - n2;
            if (n4 == 1) {
                generalPath.moveTo((float)dArray5[n2], (float)dArray8[n2]);
                generalPath.lineTo((float)dArray5[n3], (float)dArray8[n3]);
            } else {
                CurveSmoothing.computeBezierOpen(dArray5, dArray6, dArray7, n2, n4 + 1);
                CurveSmoothing.computeBezierOpen(dArray8, dArray9, dArray10, n2, n4 + 1);
                generalPath.moveTo((float)dArray5[n2], (float)dArray8[n2]);
                for (int i = n2; i < n3; ++i) {
                    generalPath.curveTo((float)dArray6[i], (float)dArray9[i], (float)dArray7[i], (float)dArray10[i], (float)dArray5[i + 1], (float)dArray8[i + 1]);
                }
            }
            n2 = n3;
        }
        return generalPath;
    }

    public Rectangle2D getBoundingBox() {
        return this.myBoundingBox;
    }

    public Paint getBackgroundPaint() {
        return this.myBackgroundPaint;
    }
}

