/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.XYSeries;
import edu.rit.numeric.plot.impl.PlotSeries;
import edu.rit.swing.Drawable;
import java.awt.Paint;
import java.awt.Stroke;

public class SegmentedPlotSeries
extends PlotSeries {
    protected XYSeries myDataSeries;

    public SegmentedPlotSeries(XYSeries xYSeries, Drawable drawable) {
        this(xYSeries, drawable, null, null);
    }

    public SegmentedPlotSeries(XYSeries xYSeries, Stroke stroke, Paint paint) {
        this(xYSeries, null, stroke, paint);
    }

    public SegmentedPlotSeries(XYSeries xYSeries, Drawable drawable, Stroke stroke, Paint paint) {
        super(drawable, stroke, paint, false);
        if (xYSeries == null) {
            throw new NullPointerException();
        }
        this.myDataSeries = xYSeries;
    }

    public XYSeries getDataSeries() {
        return this.myDataSeries;
    }

    public int getDotCount() {
        int n = this.myDataSeries.length();
        return n % 2 == 0 ? n : n - 1;
    }

    public double getDotX(int n) {
        return this.myDataSeries.x(n);
    }

    public double getDotY(int n) {
        return this.myDataSeries.y(n);
    }

    public int getLineCount() {
        return this.myDataSeries.length() / 2;
    }

    public double getLineX1(int n) {
        return this.myDataSeries.x(2 * n);
    }

    public double getLineY1(int n) {
        return this.myDataSeries.y(2 * n);
    }

    public double getLineX2(int n) {
        return this.myDataSeries.x(2 * n + 1);
    }

    public double getLineY2(int n) {
        return this.myDataSeries.y(2 * n + 1);
    }
}

