/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.plot.impl.Axis;
import edu.rit.numeric.plot.impl.Ticks;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;

public abstract class NumericalAxis
extends Axis {
    protected Ticks myTicksBelowOrLeft;
    protected Ticks myTicksAboveOrRight;

    protected NumericalAxis(double d, Stroke stroke, Paint paint, Ticks ticks, Ticks ticks2) {
        super(d, stroke, paint);
        this.myTicksBelowOrLeft = ticks;
        this.myTicksAboveOrRight = ticks2;
    }

    public Ticks getTicksBelowOrLeft() {
        return this.myTicksBelowOrLeft;
    }

    public Ticks getTicksAboveOrRight() {
        return this.myTicksAboveOrRight;
    }

    public void drawHorizontal(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.myTicksBelowOrLeft != null || this.myTicksAboveOrRight != null) {
            int n = this.getMajorDivisionCount();
            int n2 = this.getMinorDivisionCount();
            int n3 = n2 / n;
            for (int i = 0; i <= n2; ++i) {
                double d = this.getMinorDivision(i);
                graphics2D.translate(this.getDisplayDistance(d), 0.0);
                if (this.myTicksBelowOrLeft != null) {
                    if (i % n3 == 0) {
                        this.myTicksBelowOrLeft.drawBelow(graphics2D, d);
                    } else {
                        this.myTicksBelowOrLeft.drawBelow(graphics2D);
                    }
                }
                if (this.myTicksAboveOrRight != null) {
                    if (i % n3 == 0) {
                        this.myTicksAboveOrRight.drawAbove(graphics2D, d);
                    } else {
                        this.myTicksAboveOrRight.drawAbove(graphics2D);
                    }
                }
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, this.myLength, 0.0));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public void drawVertical(Graphics2D graphics2D) {
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.myTicksBelowOrLeft != null || this.myTicksAboveOrRight != null) {
            int n = this.getMajorDivisionCount();
            int n2 = this.getMinorDivisionCount();
            int n3 = n2 / n;
            for (int i = 0; i <= n2; ++i) {
                double d = this.getMinorDivision(i);
                graphics2D.translate(0.0, -this.getDisplayDistance(d));
                if (this.myTicksBelowOrLeft != null) {
                    if (i % n3 == 0) {
                        this.myTicksBelowOrLeft.drawLeft(graphics2D, d);
                    } else {
                        this.myTicksBelowOrLeft.drawLeft(graphics2D);
                    }
                }
                if (this.myTicksAboveOrRight != null) {
                    if (i % n3 == 0) {
                        this.myTicksAboveOrRight.drawRight(graphics2D, d);
                    } else {
                        this.myTicksAboveOrRight.drawRight(graphics2D);
                    }
                }
                graphics2D.setTransform(affineTransform);
            }
        }
        graphics2D.setStroke(this.myStroke);
        graphics2D.setPaint(this.myPaint);
        graphics2D.draw(new Line2D.Double(0.0, 0.0, 0.0, -this.myLength));
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    public abstract boolean includesValue(double var1);

    public abstract double getDisplayDistance(double var1);

    public abstract double getStart();

    public abstract double getEnd();

    public abstract int getMajorDivisionCount();

    public abstract double getMajorDivision(int var1);

    public abstract int getMinorDivisionCount();

    public abstract double getMinorDivision(int var1);

    public abstract double getCrossing();
}

