/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.swing.Drawable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.text.AttributedString;
import java.util.HashMap;

public class Label
implements Drawable {
    public static final int ABOVE_LEFT = 0;
    public static final int ABOVE = 1;
    public static final int ABOVE_RIGHT = 2;
    public static final int LEFT = 3;
    public static final int CENTER = 4;
    public static final int RIGHT = 5;
    public static final int BELOW_LEFT = 6;
    public static final int BELOW = 7;
    public static final int BELOW_RIGHT = 8;
    public static final int ROTATE_LEFT = 9;
    public static final int ROTATE_RIGHT = 18;
    public static final int ROTATE_AROUND = 27;
    public static final int PIXEL_COORDINATES = 36;
    public static final Font DEFAULT_FONT = new Font("sanserif", 0, 12);
    public static final Paint DEFAULT_PAINT = Color.black;
    protected String myText;
    protected double myLocationX;
    protected double myLocationY;
    protected int myPositioning;
    protected double myOffset;
    protected Font myFont;
    protected Paint myPaint;
    protected Paint myBackground;

    public Label(String string, double d, double d2) {
        this(string, d, d2, 4, 0.0, DEFAULT_FONT, DEFAULT_PAINT, null);
    }

    public Label(String string, double d, double d2, int n) {
        this(string, d, d2, n, 0.0, DEFAULT_FONT, DEFAULT_PAINT, null);
    }

    public Label(String string, double d, double d2, int n, double d3) {
        this(string, d, d2, n, d3, DEFAULT_FONT, DEFAULT_PAINT, null);
    }

    public Label(String string, double d, double d2, int n, double d3, Font font) {
        this(string, d, d2, n, d3, font, DEFAULT_PAINT, null);
    }

    public Label(String string, double d, double d2, int n, double d3, Font font, Paint paint) {
        this(string, d, d2, n, d3, font, paint, null);
    }

    public Label(String string, double d, double d2, int n, double d3, Font font, Paint paint, Paint paint2) {
        if (string == null || font == null || paint == null) {
            throw new NullPointerException();
        }
        if (0 > n || n > 71 || d3 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.myText = string;
        this.myLocationX = d;
        this.myLocationY = d2;
        this.myPositioning = n;
        this.myOffset = d3;
        this.myFont = font;
        this.myPaint = paint;
        this.myBackground = paint2;
    }

    public String getText() {
        return this.myText;
    }

    public double getLocationX() {
        return this.myLocationX;
    }

    public double getLocationY() {
        return this.myLocationY;
    }

    public int getPositioning() {
        return this.myPositioning;
    }

    public double getOffset() {
        return this.myOffset;
    }

    public Font getFont() {
        return this.myFont;
    }

    public Paint getPaint() {
        return this.myPaint;
    }

    public Paint getBackground() {
        return this.myBackground;
    }

    public void draw(Graphics2D graphics2D) {
        double d;
        double d2;
        Object object;
        Object object2;
        int n;
        Paint paint = graphics2D.getPaint();
        Font font = graphics2D.getFont();
        AffineTransform affineTransform = graphics2D.getTransform();
        int n2 = this.myText.length();
        StringBuilder stringBuilder = new StringBuilder();
        for (n = 0; n < n2; ++n) {
            int n3;
            char c = this.myText.charAt(n);
            if (c == '<') {
                n3 = this.myText.indexOf(62, n);
                if (n3 == -1) {
                    n3 = n2 - 1;
                }
                n = n3;
                continue;
            }
            if (c == '&') {
                n3 = this.myText.indexOf(59, n);
                if (n3 == -1) {
                    n3 = n2 - 1;
                }
                if (((String)(object2 = this.myText.substring(n, n3 + 1))).equals("&lt;")) {
                    stringBuilder.append('<');
                } else if (((String)object2).equals("&gt;")) {
                    stringBuilder.append('>');
                } else if (((String)object2).equals("&amp;")) {
                    stringBuilder.append('&');
                }
                n = n3;
                continue;
            }
            stringBuilder.append(c);
        }
        AttributedString attributedString = new AttributedString(stringBuilder.toString());
        HashMap<TextAttribute, Serializable> hashMap = new HashMap<TextAttribute, Serializable>();
        object2 = this.myFont.deriveFont(hashMap);
        int n4 = 0;
        for (n = 0; n < n2; ++n) {
            int n5;
            char c = this.myText.charAt(n);
            if (c == '<') {
                AffineTransform affineTransform2;
                n5 = this.myText.indexOf(62, n);
                if (n5 == -1) {
                    n5 = n2 - 1;
                }
                if (((String)(object = this.myText.substring(n, n5 + 1))).equalsIgnoreCase("<B>")) {
                    hashMap.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                } else if (((String)object).equalsIgnoreCase("</B>")) {
                    hashMap.remove(TextAttribute.WEIGHT);
                } else if (((String)object).equalsIgnoreCase("<I>")) {
                    hashMap.put(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE);
                } else if (((String)object).equalsIgnoreCase("</I>")) {
                    hashMap.remove(TextAttribute.POSTURE);
                } else if (((String)object).equalsIgnoreCase("<SUP>")) {
                    affineTransform2 = new AffineTransform();
                    affineTransform2.scale(0.6666666666666666, 0.6666666666666666);
                    affineTransform2.translate(0.0, (double)(-this.myFont.getSize2D()) * 2.0 / 3.0);
                    hashMap.put(TextAttribute.TRANSFORM, affineTransform2);
                } else if (((String)object).equalsIgnoreCase("</SUP>")) {
                    hashMap.remove(TextAttribute.TRANSFORM);
                } else if (((String)object).equalsIgnoreCase("<SUB>")) {
                    affineTransform2 = new AffineTransform();
                    affineTransform2.scale(0.6666666666666666, 0.6666666666666666);
                    affineTransform2.translate(0.0, (double)this.myFont.getSize2D() / 3.0);
                    hashMap.put(TextAttribute.TRANSFORM, affineTransform2);
                } else if (((String)object).equalsIgnoreCase("</SUB>")) {
                    hashMap.remove(TextAttribute.TRANSFORM);
                }
                object2 = this.myFont.deriveFont(hashMap);
                n = n5;
                continue;
            }
            if (c == '&') {
                n5 = this.myText.indexOf(59, n);
                if (n5 == -1) {
                    n5 = n2 - 1;
                }
                if (((String)(object = this.myText.substring(n, n5 + 1))).equals("&lt;") || ((String)object).equals("&gt;") || ((String)object).equals("&amp;")) {
                    attributedString.addAttribute(TextAttribute.FONT, object2, n4, n4 + 1);
                    ++n4;
                }
                n = n5;
                continue;
            }
            attributedString.addAttribute(TextAttribute.FONT, object2, n4, n4 + 1);
            ++n4;
        }
        graphics2D.setFont(this.myFont);
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        TextLayout textLayout = new TextLayout(attributedString.getIterator(), fontRenderContext);
        object = textLayout.getBounds();
        double d3 = ((RectangularShape)object).getWidth();
        LineMetrics lineMetrics = this.myFont.getLineMetrics("Eg", fontRenderContext);
        double d4 = lineMetrics.getAscent();
        double d5 = lineMetrics.getDescent();
        double d6 = d4 + d5;
        int n6 = this.myPositioning % 9;
        int n7 = this.myPositioning / 9 % 4 * 9;
        switch (n7) {
            case 9: 
            case 18: {
                d2 = d6;
                d = d3;
                break;
            }
            default: {
                d2 = d3;
                d = d6;
            }
        }
        switch (n6) {
            case 0: {
                graphics2D.translate(-d2 / 2.0 - this.myOffset, -d / 2.0 - this.myOffset);
                break;
            }
            case 1: {
                graphics2D.translate(0.0, -d / 2.0 - this.myOffset);
                break;
            }
            case 2: {
                graphics2D.translate(d2 / 2.0 + this.myOffset, -d / 2.0 - this.myOffset);
                break;
            }
            case 3: {
                graphics2D.translate(-d2 / 2.0 - this.myOffset, 0.0);
                break;
            }
            case 5: {
                graphics2D.translate(d2 / 2.0 + this.myOffset, 0.0);
                break;
            }
            case 6: {
                graphics2D.translate(-d2 / 2.0 - this.myOffset, d / 2.0 + this.myOffset);
                break;
            }
            case 7: {
                graphics2D.translate(0.0, d / 2.0 + this.myOffset);
                break;
            }
            case 8: {
                graphics2D.translate(d2 / 2.0 + this.myOffset, d / 2.0 + this.myOffset);
            }
        }
        switch (n7) {
            case 9: {
                graphics2D.rotate(-1.5707963267948966);
                break;
            }
            case 18: {
                graphics2D.rotate(1.5707963267948966);
                break;
            }
            case 27: {
                graphics2D.rotate(Math.PI);
            }
        }
        if (this.myBackground != null) {
            graphics2D.setPaint(this.myBackground);
            graphics2D.fill(new Rectangle2D.Double(-d3 / 2.0, -d6 / 2.0, d3, d6));
        }
        graphics2D.setPaint(this.myPaint);
        textLayout.draw(graphics2D, (float)(-d3 / 2.0), (float)(-d6 / 2.0 + d4));
        graphics2D.setPaint(paint);
        graphics2D.setFont(font);
        graphics2D.setTransform(affineTransform);
    }
}

