/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot.impl;

import edu.rit.numeric.plot.Strokes;
import edu.rit.numeric.plot.impl.NumericalAxis;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;

public class Grid {
    public static final Stroke DEFAULT_STROKE = Strokes.solid(0.2);
    public static final Paint DEFAULT_PAINT = Color.black;
    private Stroke myMajorStroke;
    private Paint myMajorPaint;
    private Stroke myMinorStroke;
    private Paint myMinorPaint;

    public Grid() {
        this(DEFAULT_STROKE, DEFAULT_PAINT, null, null);
    }

    public Grid(Stroke stroke, Paint paint) {
        this(stroke, paint, null, null);
    }

    public Grid(Stroke stroke, Paint paint, Stroke stroke2, Paint paint2) {
        this.myMajorStroke = stroke;
        this.myMajorPaint = paint;
        this.myMinorStroke = stroke2;
        this.myMinorPaint = paint2;
    }

    void drawHorizontalGridlines(Graphics2D graphics2D, NumericalAxis numericalAxis, double d) {
        double d2;
        int n;
        int n2;
        boolean bl;
        boolean bl2 = this.myMajorStroke != null && this.myMajorPaint != null;
        boolean bl3 = bl = this.myMinorStroke != null && this.myMinorPaint != null;
        if (!bl2 && !bl) {
            return;
        }
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        if (bl) {
            graphics2D.setStroke(this.myMinorStroke);
            graphics2D.setPaint(this.myMinorPaint);
            n2 = numericalAxis.getMinorDivisionCount();
            for (n = 0; n <= n2; ++n) {
                d2 = numericalAxis.getDisplayDistance(numericalAxis.getMinorDivision(n));
                graphics2D.draw(new Line2D.Double(0.0, -d2, d, -d2));
            }
        }
        if (bl2) {
            graphics2D.setStroke(this.myMajorStroke);
            graphics2D.setPaint(this.myMajorPaint);
            n2 = numericalAxis.getMajorDivisionCount();
            for (n = 0; n <= n2; ++n) {
                d2 = numericalAxis.getDisplayDistance(numericalAxis.getMajorDivision(n));
                graphics2D.draw(new Line2D.Double(0.0, -d2, d, -d2));
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }

    void drawVerticalGridlines(Graphics2D graphics2D, NumericalAxis numericalAxis, double d) {
        double d2;
        int n;
        int n2;
        boolean bl;
        boolean bl2 = this.myMajorStroke != null && this.myMajorPaint != null;
        boolean bl3 = bl = this.myMinorStroke != null && this.myMinorPaint != null;
        if (!bl2 && !bl) {
            return;
        }
        Stroke stroke = graphics2D.getStroke();
        Paint paint = graphics2D.getPaint();
        if (bl) {
            graphics2D.setStroke(this.myMinorStroke);
            graphics2D.setPaint(this.myMinorPaint);
            n2 = numericalAxis.getMinorDivisionCount();
            for (n = 0; n <= n2; ++n) {
                d2 = numericalAxis.getDisplayDistance(numericalAxis.getMinorDivision(n));
                graphics2D.draw(new Line2D.Double(d2, 0.0, d2, -d));
            }
        }
        if (bl2) {
            graphics2D.setStroke(this.myMajorStroke);
            graphics2D.setPaint(this.myMajorPaint);
            n2 = numericalAxis.getMajorDivisionCount();
            for (n = 0; n <= n2; ++n) {
                d2 = numericalAxis.getDisplayDistance(numericalAxis.getMajorDivision(n));
                graphics2D.draw(new Line2D.Double(d2, 0.0, d2, -d));
            }
        }
        graphics2D.setStroke(stroke);
        graphics2D.setPaint(paint);
    }
}

