/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.numeric.plot.AxisDialog;
import edu.rit.numeric.plot.Plot;
import edu.rit.numeric.plot.PlotAreaDialog;
import edu.rit.numeric.plot.PlotMarginsDialog;
import edu.rit.numeric.plot.TitleDialog;
import edu.rit.swing.Displayable;
import edu.rit.swing.DisplayableFrame;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

class PlotFrame
extends DisplayableFrame {
    private Plot myPlot;
    private TitleDialog myPlotTitleDialog;
    private PlotMarginsDialog myPlotMarginsDialog;
    private PlotAreaDialog myPlotAreaDialog;
    private AxisDialog myXAxisDialog;
    private TitleDialog myXAxisTitleDialog;
    private AxisDialog myYAxisDialog;
    private TitleDialog myYAxisTitleDialog;

    public PlotFrame(Plot plot, Displayable displayable) {
        super(displayable);
        this.initialize(plot);
    }

    public PlotFrame(String string, Plot plot, Displayable displayable) {
        super(string, displayable);
        this.initialize(plot);
    }

    public PlotFrame(Plot plot, Displayable displayable, int n) {
        super(displayable, n);
        this.initialize(plot);
    }

    public PlotFrame(String string, Plot plot, Displayable displayable, int n) {
        super(string, displayable, n);
        this.initialize(plot);
    }

    private void initialize(Plot plot) {
        if (plot == null) {
            throw new NullPointerException("PlotFrame(): thePlot is null");
        }
        this.myPlot = plot;
        JMenu jMenu = new JMenu("Format");
        jMenu.setMnemonic(79);
        JMenuItem jMenuItem = new JMenuItem("Plot Title...", 80);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doPlotTitle();
            }
        });
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Margins...", 77);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doMargins();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Plot Area...", 65);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doPlotArea();
            }
        });
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("X Axis...", 88);
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doXAxis();
            }
        });
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("X Axis Title...", 73);
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doXAxisTitle();
            }
        });
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Y Axis...", 89);
        jMenuItem6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doYAxis();
            }
        });
        jMenu.add(jMenuItem6);
        JMenuItem jMenuItem7 = new JMenuItem("Y Axis Title...", 84);
        jMenuItem7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotFrame.this.doYAxisTitle();
            }
        });
        jMenu.add(jMenuItem7);
        JMenuBar jMenuBar = this.getJMenuBar();
        jMenuBar.add(jMenu);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                PlotFrame.this.doClose();
            }
        });
    }

    private void doPlotTitle() {
        if (this.myPlotTitleDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myPlotTitleDialog = new TitleDialog((Frame)this, "Plot");
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatPlotTitle(this.myPlotTitleDialog);
    }

    private void doMargins() {
        if (this.myPlotMarginsDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myPlotMarginsDialog = new PlotMarginsDialog(this);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatPlotMargins(this.myPlotMarginsDialog);
    }

    private void doPlotArea() {
        if (this.myPlotAreaDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myPlotAreaDialog = new PlotAreaDialog(this);
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatPlotArea(this.myPlotAreaDialog);
    }

    private void doXAxis() {
        if (this.myXAxisDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myXAxisDialog = new AxisDialog((Frame)this, "X");
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatXAxis(this.myXAxisDialog);
    }

    private void doXAxisTitle() {
        if (this.myXAxisTitleDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myXAxisTitleDialog = new TitleDialog((Frame)this, "X Axis");
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatXAxisTitle(this.myXAxisTitleDialog);
    }

    private void doYAxis() {
        if (this.myYAxisDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myYAxisDialog = new AxisDialog((Frame)this, "Y");
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatYAxis(this.myYAxisDialog);
    }

    private void doYAxisTitle() {
        if (this.myYAxisTitleDialog == null) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.myYAxisTitleDialog = new TitleDialog((Frame)this, "Y Axis");
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.myPlot.formatYAxisTitle(this.myYAxisTitleDialog);
    }

    private void doClose() {
        if (this.myPlotTitleDialog != null) {
            this.myPlotTitleDialog.dispose();
            this.myPlotTitleDialog = null;
        }
        if (this.myPlotMarginsDialog != null) {
            this.myPlotMarginsDialog.dispose();
            this.myPlotMarginsDialog = null;
        }
        if (this.myPlotAreaDialog != null) {
            this.myPlotAreaDialog.dispose();
            this.myPlotAreaDialog = null;
        }
        if (this.myXAxisTitleDialog != null) {
            this.myXAxisTitleDialog.dispose();
            this.myXAxisTitleDialog = null;
        }
        if (this.myYAxisTitleDialog != null) {
            this.myYAxisTitleDialog.dispose();
            this.myYAxisTitleDialog = null;
        }
    }
}

