/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.swing.DoubleTextField;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class PlotAreaDialog
extends JDialog {
    private static final int GAP = 10;
    private DoubleTextField myPlotAreaWidth;
    private DoubleTextField myPlotAreaHeight;
    private JRadioButton myMajorGridLinesOn;
    private JRadioButton myMajorGridLinesOff;
    private JRadioButton myMinorGridLinesOn;
    private JRadioButton myMinorGridLinesOff;
    private boolean okButtonClicked;

    public PlotAreaDialog(Frame frame) {
        super(frame, "Format Plot Area", true);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Plot Area Width");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myPlotAreaWidth = new DoubleTextField(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myPlotAreaWidth, gridBagConstraints);
        container.add(this.myPlotAreaWidth);
        jLabel = new JLabel("Plot Area Height");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myPlotAreaHeight = new DoubleTextField(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myPlotAreaHeight, gridBagConstraints);
        container.add(this.myPlotAreaHeight);
        jLabel = new JLabel("Major Grid Lines");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.myMajorGridLinesOn = new JRadioButton("On");
        jPanel.add(this.myMajorGridLinesOn);
        buttonGroup.add(this.myMajorGridLinesOn);
        jPanel.add(Box.createHorizontalStrut(10));
        this.myMajorGridLinesOff = new JRadioButton("Off");
        jPanel.add(this.myMajorGridLinesOff);
        buttonGroup.add(this.myMajorGridLinesOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        jLabel = new JLabel("Minor Grid Lines");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.myMinorGridLinesOn = new JRadioButton("On");
        jPanel2.add(this.myMinorGridLinesOn);
        buttonGroup2.add(this.myMinorGridLinesOn);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.myMinorGridLinesOff = new JRadioButton("Off");
        jPanel2.add(this.myMinorGridLinesOff);
        buttonGroup2.add(this.myMinorGridLinesOff);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        JButton jButton = new JButton("OK");
        jPanel3.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotAreaDialog.this.doOkay();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jPanel3.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlotAreaDialog.this.doCancel();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        container.add(jPanel3);
        this.getRootPane().setDefaultButton(jButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                PlotAreaDialog.this.myPlotAreaWidth.setSelectionStart(Integer.MAX_VALUE);
                PlotAreaDialog.this.myPlotAreaWidth.setSelectionEnd(Integer.MAX_VALUE);
                PlotAreaDialog.this.myPlotAreaWidth.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent windowEvent) {
                PlotAreaDialog.this.doCancel();
            }
        });
        this.pack();
    }

    public void setPlotAreaWidth(double d) {
        this.myPlotAreaWidth.value(d);
    }

    public void setPlotAreaHeight(double d) {
        this.myPlotAreaHeight.value(d);
    }

    public void setMajorGridLines(boolean bl) {
        if (bl) {
            this.myMajorGridLinesOn.setSelected(true);
        } else {
            this.myMajorGridLinesOff.setSelected(true);
        }
    }

    public void setMinorGridLines(boolean bl) {
        if (bl) {
            this.myMinorGridLinesOn.setSelected(true);
        } else {
            this.myMinorGridLinesOff.setSelected(true);
        }
    }

    public boolean isOkay() {
        return this.okButtonClicked;
    }

    public double getPlotAreaWidth() {
        return this.myPlotAreaWidth.value();
    }

    public double getPlotAreaHeight() {
        return this.myPlotAreaHeight.value();
    }

    public boolean getMajorGridLines() {
        return this.myMajorGridLinesOn.isSelected();
    }

    public boolean getMinorGridLines() {
        return this.myMinorGridLinesOn.isSelected();
    }

    private void doOkay() {
        if (this.myPlotAreaWidth.isValid(0.0, Double.MAX_VALUE) && this.myPlotAreaHeight.isValid(0.0, Double.MAX_VALUE)) {
            this.okButtonClicked = true;
            this.setVisible(false);
        }
    }

    private void doCancel() {
        this.okButtonClicked = false;
        this.setVisible(false);
    }
}

