/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.swing.Drawable;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;

public class Dots {
    private Dots() {
    }

    public static Drawable circle() {
        return new Ellipse(Color.black, null, null, 5.0, 5.0);
    }

    public static Drawable circle(double d) {
        return new Ellipse(Color.black, null, null, d, d);
    }

    public static Drawable circle(Paint paint) {
        return new Ellipse(paint, null, null, 5.0, 5.0);
    }

    public static Drawable circle(Paint paint, Stroke stroke, Paint paint2) {
        return new Ellipse(paint, stroke, paint2, 5.0, 5.0);
    }

    public static Drawable circle(Paint paint, Stroke stroke, Paint paint2, double d) {
        return new Ellipse(paint, stroke, paint2, d, d);
    }

    public static Drawable ellipse(double d, double d2) {
        return new Ellipse(Color.black, null, null, d, d2);
    }

    public static Drawable ellipse(Paint paint, double d, double d2) {
        return new Ellipse(paint, null, null, d, d2);
    }

    public static Drawable ellipse(Paint paint, Stroke stroke, Paint paint2, double d, double d2) {
        return new Ellipse(paint, stroke, paint2, d, d2);
    }

    public static Drawable diamond() {
        return new Rectangle(Color.black, null, null, 5.0, 5.0, 0.7853981633974483);
    }

    public static Drawable diamond(double d) {
        return new Rectangle(Color.black, null, null, d, d, 0.7853981633974483);
    }

    public static Drawable diamond(Paint paint) {
        return new Rectangle(paint, null, null, 5.0, 5.0, 0.7853981633974483);
    }

    public static Drawable diamond(Paint paint, Stroke stroke, Paint paint2) {
        return new Rectangle(paint, stroke, paint2, 5.0, 5.0, 0.7853981633974483);
    }

    public static Drawable diamond(Paint paint, Stroke stroke, Paint paint2, double d) {
        return new Rectangle(paint, stroke, paint2, d, d, 0.7853981633974483);
    }

    public static Drawable square() {
        return new Rectangle(Color.black, null, null, 5.0, 5.0, 0.0);
    }

    public static Drawable square(double d) {
        return new Rectangle(Color.black, null, null, d, d, 0.0);
    }

    public static Drawable square(Paint paint) {
        return new Rectangle(paint, null, null, 5.0, 5.0, 0.0);
    }

    public static Drawable square(Paint paint, Stroke stroke, Paint paint2) {
        return new Rectangle(paint, stroke, paint2, 5.0, 5.0, 0.0);
    }

    public static Drawable square(Paint paint, Stroke stroke, Paint paint2, double d) {
        return new Rectangle(paint, stroke, paint2, d, d, 0.0);
    }

    private static class Rectangle
    implements Drawable {
        private Paint myFillPaint;
        private Stroke myOutlineStroke;
        private Paint myOutlinePaint;
        private Rectangle2D.Double myRectangle;
        private double myAngle;

        public Rectangle(Paint paint, Stroke stroke, Paint paint2, double d, double d2, double d3) {
            this.myFillPaint = paint;
            this.myOutlineStroke = stroke;
            this.myOutlinePaint = paint2;
            this.myRectangle = new Rectangle2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
            this.myAngle = d3;
        }

        public void draw(Graphics2D graphics2D) {
            Paint paint = graphics2D.getPaint();
            AffineTransform affineTransform = graphics2D.getTransform();
            graphics2D.rotate(this.myAngle);
            if (this.myFillPaint != null) {
                graphics2D.setPaint(this.myFillPaint);
                graphics2D.fill(this.myRectangle);
            }
            if (this.myOutlineStroke != null && this.myOutlinePaint != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.myOutlineStroke);
                graphics2D.setPaint(this.myOutlinePaint);
                graphics2D.draw(this.myRectangle);
                graphics2D.setStroke(stroke);
            }
            graphics2D.setPaint(paint);
            graphics2D.setTransform(affineTransform);
        }
    }

    private static class Ellipse
    implements Drawable {
        private Paint myFillPaint;
        private Stroke myOutlineStroke;
        private Paint myOutlinePaint;
        private Ellipse2D.Double myEllipse;

        public Ellipse(Paint paint, Stroke stroke, Paint paint2, double d, double d2) {
            this.myFillPaint = paint;
            this.myOutlineStroke = stroke;
            this.myOutlinePaint = paint2;
            this.myEllipse = new Ellipse2D.Double(-d / 2.0, -d2 / 2.0, d, d2);
        }

        public void draw(Graphics2D graphics2D) {
            Paint paint = graphics2D.getPaint();
            if (this.myFillPaint != null) {
                graphics2D.setPaint(this.myFillPaint);
                graphics2D.fill(this.myEllipse);
            }
            if (this.myOutlineStroke != null && this.myOutlinePaint != null) {
                Stroke stroke = graphics2D.getStroke();
                graphics2D.setStroke(this.myOutlineStroke);
                graphics2D.setPaint(this.myOutlinePaint);
                graphics2D.draw(this.myEllipse);
                graphics2D.setStroke(stroke);
            }
            graphics2D.setPaint(paint);
        }
    }
}

