/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric.plot;

import edu.rit.numeric.plot.Plot;
import edu.rit.swing.DecimalFormatTextField;
import edu.rit.swing.DoubleTextField;
import edu.rit.swing.FontSelector;
import edu.rit.swing.IntegerTextField;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.DecimalFormat;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class AxisDialog
extends JDialog {
    private static final int GAP = 10;
    private JRadioButton myLinearButton;
    private JRadioButton myLogarithmicButton;
    private DoubleTextField myAxisStart;
    private JCheckBox myAxisStartAuto;
    private DoubleTextField myAxisEnd;
    private JCheckBox myAxisEndAuto;
    private IntegerTextField myAxisMajorDivisions;
    private JCheckBox myAxisMajorDivisionsAuto;
    private IntegerTextField myAxisMinorDivisions;
    private JCheckBox myAxisMinorDivisionsAuto;
    private DoubleTextField myAxisCrossing;
    private JCheckBox myAxisCrossingAuto;
    private FontSelector myAxisTickFont;
    private DecimalFormatTextField myAxisTickFormat;
    private DoubleTextField myAxisTickScale;
    private boolean okButtonClicked;

    public AxisDialog(Frame frame, String string) {
        super(frame, "Format " + string + " Axis", true);
        Container container = this.getContentPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        container.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel("Kind");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.myLinearButton = new JRadioButton("Linear");
        jPanel.add(this.myLinearButton);
        buttonGroup.add(this.myLinearButton);
        jPanel.add(Box.createHorizontalStrut(10));
        this.myLogarithmicButton = new JRadioButton("Logarithmic");
        jPanel.add(this.myLogarithmicButton);
        buttonGroup.add(this.myLogarithmicButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        container.add(jPanel);
        jLabel = new JLabel("Start Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.myAxisStart = new DoubleTextField(10);
        jPanel2.add(this.myAxisStart);
        jPanel2.add(Box.createHorizontalStrut(10));
        this.myAxisStartAuto = new JCheckBox("Automatic");
        jPanel2.add(this.myAxisStartAuto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        container.add(jPanel2);
        this.myAxisStartAuto.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AxisDialog.this.myAxisStart.setEnabled(!AxisDialog.this.myAxisStartAuto.isSelected());
            }
        });
        jLabel = new JLabel("End Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 0));
        this.myAxisEnd = new DoubleTextField(10);
        jPanel3.add(this.myAxisEnd);
        jPanel3.add(Box.createHorizontalStrut(10));
        this.myAxisEndAuto = new JCheckBox("Automatic");
        jPanel3.add(this.myAxisEndAuto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        container.add(jPanel3);
        this.myAxisEndAuto.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AxisDialog.this.myAxisEnd.setEnabled(!AxisDialog.this.myAxisEndAuto.isSelected());
            }
        });
        jLabel = new JLabel("Major Divisions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.myAxisMajorDivisions = new IntegerTextField(10);
        jPanel4.add(this.myAxisMajorDivisions);
        jPanel4.add(Box.createHorizontalStrut(10));
        this.myAxisMajorDivisionsAuto = new JCheckBox("Automatic");
        jPanel4.add(this.myAxisMajorDivisionsAuto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        container.add(jPanel4);
        this.myAxisMajorDivisionsAuto.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AxisDialog.this.myAxisMajorDivisions.setEnabled(!AxisDialog.this.myAxisMajorDivisionsAuto.isSelected());
            }
        });
        jLabel = new JLabel("Minor Divisions");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.myAxisMinorDivisions = new IntegerTextField(10);
        jPanel5.add(this.myAxisMinorDivisions);
        jPanel5.add(Box.createHorizontalStrut(10));
        this.myAxisMinorDivisionsAuto = new JCheckBox("Automatic");
        jPanel5.add(this.myAxisMinorDivisionsAuto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        container.add(jPanel5);
        this.myAxisMinorDivisionsAuto.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AxisDialog.this.myAxisMinorDivisions.setEnabled(!AxisDialog.this.myAxisMinorDivisionsAuto.isSelected());
            }
        });
        jLabel = new JLabel("Crossing Value");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        this.myAxisCrossing = new DoubleTextField(10);
        jPanel6.add(this.myAxisCrossing);
        jPanel6.add(Box.createHorizontalStrut(10));
        this.myAxisCrossingAuto = new JCheckBox("Automatic");
        jPanel6.add(this.myAxisCrossingAuto);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel6, gridBagConstraints);
        container.add(jPanel6);
        this.myAxisCrossingAuto.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AxisDialog.this.myAxisCrossing.setEnabled(!AxisDialog.this.myAxisCrossingAuto.isSelected());
            }
        });
        jLabel = new JLabel("Tick Font");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myAxisTickFont = new FontSelector();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myAxisTickFont, gridBagConstraints);
        container.add(this.myAxisTickFont);
        jLabel = new JLabel("Tick Format");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myAxisTickFormat = new DecimalFormatTextField(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myAxisTickFormat, gridBagConstraints);
        container.add(this.myAxisTickFormat);
        jLabel = new JLabel("Scale Factor");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        container.add(jLabel);
        this.myAxisTickScale = new DoubleTextField(10);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.insets = new Insets(0, 0, 10, 10);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.myAxisTickScale, gridBagConstraints);
        container.add(this.myAxisTickScale);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 0));
        JButton jButton = new JButton("OK");
        jPanel7.add(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AxisDialog.this.doOkay();
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jPanel7.add(jButton2);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AxisDialog.this.doCancel();
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        container.add(jPanel7);
        this.getRootPane().setDefaultButton(jButton);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowActivated(WindowEvent windowEvent) {
                AxisDialog.this.myLinearButton.requestFocusInWindow();
            }

            public void windowClosing(WindowEvent windowEvent) {
                AxisDialog.this.doCancel();
            }
        });
        this.pack();
    }

    public void setAxisKind(Plot.AxisKind axisKind) {
        switch (axisKind) {
            case LINEAR: {
                this.myLinearButton.setSelected(true);
                break;
            }
            case LOGARITHMIC: {
                this.myLogarithmicButton.setSelected(true);
            }
        }
    }

    public void setAxisStart(double d) {
        if (Double.isNaN(d)) {
            this.myAxisStart.setText("");
            this.myAxisStart.setEnabled(false);
            this.myAxisStartAuto.setSelected(true);
        } else {
            this.myAxisStart.value(d);
            this.myAxisStart.setEnabled(true);
            this.myAxisStartAuto.setSelected(false);
        }
    }

    public void setAxisEnd(double d) {
        if (Double.isNaN(d)) {
            this.myAxisEnd.setText("");
            this.myAxisEnd.setEnabled(false);
            this.myAxisEndAuto.setSelected(true);
        } else {
            this.myAxisEnd.value(d);
            this.myAxisEnd.setEnabled(true);
            this.myAxisEndAuto.setSelected(false);
        }
    }

    public void setAxisMajorDivisions(int n) {
        if (n == 10) {
            this.myAxisMajorDivisions.setText("");
            this.myAxisMajorDivisions.setEnabled(false);
            this.myAxisMajorDivisionsAuto.setSelected(true);
        } else {
            this.myAxisMajorDivisions.value(n);
            this.myAxisMajorDivisions.setEnabled(true);
            this.myAxisMajorDivisionsAuto.setSelected(false);
        }
    }

    public void setAxisMinorDivisions(int n) {
        if (n == 1) {
            this.myAxisMinorDivisions.setText("");
            this.myAxisMinorDivisions.setEnabled(false);
            this.myAxisMinorDivisionsAuto.setSelected(true);
        } else {
            this.myAxisMinorDivisions.value(n);
            this.myAxisMinorDivisions.setEnabled(true);
            this.myAxisMinorDivisionsAuto.setSelected(false);
        }
    }

    public void setAxisCrossing(double d) {
        if (Double.isNaN(d)) {
            this.myAxisCrossing.setText("");
            this.myAxisCrossing.setEnabled(false);
            this.myAxisCrossingAuto.setSelected(true);
        } else {
            this.myAxisCrossing.value(d);
            this.myAxisCrossing.setEnabled(true);
            this.myAxisCrossingAuto.setSelected(false);
        }
    }

    public void setTickFont(Font font) {
        this.myAxisTickFont.setSelectedFont(font);
    }

    public void setTickFormat(DecimalFormat decimalFormat) {
        this.myAxisTickFormat.pattern(decimalFormat);
    }

    public void setTickScale(double d) {
        this.myAxisTickScale.value(d);
    }

    public boolean isOkay() {
        return this.okButtonClicked;
    }

    public Plot.AxisKind getAxisKind() {
        return this.myLinearButton.isSelected() ? Plot.LINEAR : Plot.LOGARITHMIC;
    }

    public double getAxisStart() {
        return this.myAxisStartAuto.isSelected() ? Double.NaN : this.myAxisStart.value();
    }

    public double getAxisEnd() {
        return this.myAxisEndAuto.isSelected() ? Double.NaN : this.myAxisEnd.value();
    }

    public int getAxisMajorDivisions() {
        return this.myAxisMajorDivisionsAuto.isSelected() ? 10 : this.myAxisMajorDivisions.value();
    }

    public int getAxisMinorDivisions() {
        return this.myAxisMinorDivisionsAuto.isSelected() ? 1 : this.myAxisMinorDivisions.value();
    }

    public double getAxisCrossing() {
        return this.myAxisCrossingAuto.isSelected() ? Double.NaN : this.myAxisCrossing.value();
    }

    public Font getTickFont() {
        return this.myAxisTickFont.getSelectedFont();
    }

    public DecimalFormat getTickFormat() {
        return this.myAxisTickFormat.pattern();
    }

    public double getTickScale() {
        return this.myAxisTickScale.value();
    }

    private void doOkay() {
        if ((this.myAxisStartAuto.isSelected() || this.myAxisStart.isValid(-1.7976931348623157E308, Double.MAX_VALUE)) && (this.myAxisEndAuto.isSelected() || this.myAxisEnd.isValid(-1.7976931348623157E308, Double.MAX_VALUE)) && (this.myAxisMajorDivisionsAuto.isSelected() || this.myAxisMajorDivisions.isValid(1, Integer.MAX_VALUE)) && (this.myAxisMinorDivisionsAuto.isSelected() || this.myAxisMinorDivisions.isValid(1, Integer.MAX_VALUE)) && (this.myAxisCrossingAuto.isSelected() || this.myAxisCrossing.isValid(-1.7976931348623157E308, Double.MAX_VALUE)) && this.myAxisTickFormat.isValid() && this.myAxisTickScale.isValid(-1.7976931348623157E308, Double.MAX_VALUE)) {
            this.okButtonClicked = true;
            this.setVisible(false);
        }
    }

    private void doCancel() {
        this.okButtonClicked = false;
        this.setVisible(false);
    }
}

