/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Series;
import edu.rit.numeric.XYSeries;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class XYZSeries {
    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract double x(int var1);

    public abstract double y(int var1);

    public abstract double z(int var1);

    public double minX() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.x(i));
        }
        return d;
    }

    public double maxX() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.x(i));
        }
        return d;
    }

    public double minY() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.y(i));
        }
        return d;
    }

    public double maxY() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.y(i));
        }
        return d;
    }

    public double minZ() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.z(i));
        }
        return d;
    }

    public double maxZ() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.z(i));
        }
        return d;
    }

    public Stats stats() {
        int n = this.length();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.x(i);
            d2 += this.y(i);
            d3 += this.z(i);
        }
        double d4 = d / (double)n;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = d2 / (double)n;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = d3 / (double)n;
        double d11 = 0.0;
        double d12 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d13 = this.x(i) - d4;
            double d14 = d13 * d13;
            d5 += d13;
            d6 += d14;
            double d15 = this.y(i) - d7;
            double d16 = d15 * d15;
            d8 += d15;
            d9 += d16;
            double d17 = this.z(i) - d10;
            double d18 = d17 * d17;
            d11 += d17;
            d12 += d18;
        }
        double d19 = (d6 - d5 * d5 / (double)n) / (double)(n - 1);
        double d20 = Math.sqrt(d19);
        double d21 = (d9 - d8 * d8 / (double)n) / (double)(n - 1);
        double d22 = Math.sqrt(d21);
        double d23 = (d12 - d11 * d11 / (double)n) / (double)(n - 1);
        double d24 = Math.sqrt(d23);
        return new Stats(d4, d19, d20, d7, d21, d22, d10, d23, d24);
    }

    public Series xSeries() {
        return new XSeriesView(this);
    }

    public Series ySeries() {
        return new YSeriesView(this);
    }

    public Series zSeries() {
        return new ZSeriesView(this);
    }

    public XYSeries xySeries() {
        return new XYSeriesView(this);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printStream.print(i);
            printStream.print('\t');
            printStream.print(this.x(i));
            printStream.print('\t');
            printStream.print(this.y(i));
            printStream.print('\t');
            printStream.println(this.z(i));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.print(this.x(i));
            printWriter.print('\t');
            printWriter.print(this.y(i));
            printWriter.print('\t');
            printWriter.println(this.z(i));
        }
    }

    private static class XYSeriesView
    extends XYSeries {
        private XYZSeries outer;

        public XYSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.x(n);
        }

        public double y(int n) {
            return this.outer.y(n);
        }
    }

    private static class ZSeriesView
    extends Series {
        private XYZSeries outer;

        public ZSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.z(n);
        }
    }

    private static class YSeriesView
    extends Series {
        private XYZSeries outer;

        public YSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.y(n);
        }
    }

    private static class XSeriesView
    extends Series {
        private XYZSeries outer;

        public XSeriesView(XYZSeries xYZSeries) {
            this.outer = xYZSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.x(n);
        }
    }

    public static class Stats {
        public final double meanX;
        public final double varX;
        public final double stddevX;
        public final double meanY;
        public final double varY;
        public final double stddevY;
        public final double meanZ;
        public final double varZ;
        public final double stddevZ;

        private Stats(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
            this.meanX = d;
            this.varX = d2;
            this.stddevX = d3;
            this.meanY = d4;
            this.varY = d5;
            this.stddevY = d6;
            this.meanZ = d7;
            this.varZ = d8;
            this.stddevZ = d9;
        }
    }
}

