/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Series;
import java.io.PrintStream;
import java.io.PrintWriter;

public abstract class XYSeries {
    private static final double TINY = 1.0E-20;

    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract double x(int var1);

    public abstract double y(int var1);

    public double minX() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.x(i));
        }
        return d;
    }

    public double maxX() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.x(i));
        }
        return d;
    }

    public double minY() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.y(i));
        }
        return d;
    }

    public double maxY() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.y(i));
        }
        return d;
    }

    public Stats stats() {
        int n = this.length();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.x(i);
            d2 += this.y(i);
        }
        double d3 = d / (double)n;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d2 / (double)n;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d9 = this.x(i) - d3;
            double d10 = d9 * d9;
            d4 += d9;
            d5 += d10;
            double d11 = this.y(i) - d6;
            double d12 = d11 * d11;
            d7 += d11;
            d8 += d12;
        }
        double d13 = (d5 - d4 * d4 / (double)n) / (double)(n - 1);
        double d14 = Math.sqrt(d13);
        double d15 = (d8 - d7 * d7 / (double)n) / (double)(n - 1);
        double d16 = Math.sqrt(d15);
        return new Stats(d3, d13, d14, d6, d15, d16);
    }

    public Regression linearRegression() {
        int n = this.length();
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.x(i);
            d2 += this.y(i);
        }
        double d3 = d / (double)n;
        double d4 = d2 / (double)n;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d9 = this.x(i) - d3;
            double d10 = this.y(i) - d4;
            d5 += d9 * d9;
            d6 += d10 * d10;
            d7 += d9 * d10;
            d8 += d9 * this.y(i);
        }
        double d11 = (d2 - d * (d8 /= d5)) / (double)n;
        double d12 = d7 / (Math.sqrt(d5 * d6) + 1.0E-20);
        return new Regression(d11, d8, d12);
    }

    public Series xSeries() {
        return new XSeriesView(this);
    }

    public Series ySeries() {
        return new YSeriesView(this);
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printStream.print(i);
            printStream.print('\t');
            printStream.print(this.x(i));
            printStream.print('\t');
            printStream.println(this.y(i));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.print(this.x(i));
            printWriter.print('\t');
            printWriter.println(this.y(i));
        }
    }

    private static class YSeriesView
    extends Series {
        private XYSeries outer;

        public YSeriesView(XYSeries xYSeries) {
            this.outer = xYSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.y(n);
        }
    }

    private static class XSeriesView
    extends Series {
        private XYSeries outer;

        public XSeriesView(XYSeries xYSeries) {
            this.outer = xYSeries;
        }

        public int length() {
            return this.outer.length();
        }

        public double x(int n) {
            return this.outer.x(n);
        }
    }

    public static class Regression {
        public final double a;
        public final double b;
        public final double corr;

        private Regression(double d, double d2, double d3) {
            this.a = d;
            this.b = d2;
            this.corr = d3;
        }
    }

    public static class Stats {
        public final double meanX;
        public final double varX;
        public final double stddevX;
        public final double meanY;
        public final double varY;
        public final double stddevY;

        private Stats(double d, double d2, double d3, double d4, double d5, double d6) {
            this.meanX = d;
            this.varX = d2;
            this.stddevX = d3;
            this.meanY = d4;
            this.varY = d5;
            this.stddevY = d6;
        }
    }
}

