/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Series
implements Iterable<Double> {
    public abstract int length();

    public boolean isEmpty() {
        return this.length() == 0;
    }

    public abstract double x(int var1);

    public double minX() {
        int n = this.length();
        double d = Double.POSITIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.min(d, this.x(i));
        }
        return d;
    }

    public double maxX() {
        int n = this.length();
        double d = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < n; ++i) {
            d = Math.max(d, this.x(i));
        }
        return d;
    }

    public Stats stats() {
        int n = this.length();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += this.x(i);
        }
        double d2 = d / (double)n;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d5 = this.x(i) - d2;
            double d6 = d5 * d5;
            d3 += d5;
            d4 += d6;
        }
        double d7 = (d4 - d3 * d3 / (double)n) / (double)(n - 1);
        double d8 = Math.sqrt(d7);
        return new Stats(d2, d7, d8);
    }

    @Override
    public Iterator<Double> iterator() {
        return new Iterator<Double>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < Series.this.length();
            }

            @Override
            public Double next() {
                try {
                    return Series.this.x(this.i++);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void print() {
        this.print(System.out);
    }

    public void print(PrintStream printStream) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printStream.print(i);
            printStream.print('\t');
            printStream.println(this.x(i));
        }
    }

    public void print(PrintWriter printWriter) {
        int n = this.length();
        for (int i = 0; i < n; ++i) {
            printWriter.print(i);
            printWriter.print('\t');
            printWriter.println(this.x(i));
        }
    }

    public static class Stats {
        public final double meanX;
        public final double varX;
        public final double stddevX;

        private Stats(double d, double d2, double d3) {
            this.meanX = d;
            this.varX = d2;
            this.stddevX = d3;
        }
    }
}

