/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

public class NonNegativeLeastSquares {
    public final int M;
    public final int N;
    public final double[][] a;
    public final double[] b;
    public final double[] x;
    public final int[] index;
    public int nsetp;
    public double normsqr;
    private final double[] w;
    private final double[] zz;
    private final double[] terms;
    private final int itmax;
    private static final double factor = 0.01;

    public NonNegativeLeastSquares(int n, int n2) {
        if (n <= 0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares(): M = " + n + " illegal");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares(): N = " + n2 + " illegal");
        }
        this.M = n;
        this.N = n2;
        this.a = new double[n][n2];
        this.b = new double[n];
        this.x = new double[n2];
        this.index = new int[n2];
        this.w = new double[n2];
        this.zz = new double[n];
        this.terms = new double[2];
        this.itmax = 3 * n2;
    }

    public void solve() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.N; ++n) {
            this.x[n] = 0.0;
            this.index[n] = n;
        }
        this.nsetp = 0;
        block1: while (this.nsetp < this.N && this.nsetp < this.M) {
            int n3;
            int n4;
            double d;
            int n5;
            int n6;
            int n7;
            for (n7 = this.nsetp; n7 < this.N; ++n7) {
                n6 = this.index[n7];
                double d2 = 0.0;
                for (n5 = this.nsetp; n5 < this.M; ++n5) {
                    d2 += this.a[n5][n6] * this.b[n5];
                }
                this.w[n6] = d2;
            }
            while (true) {
                double d3 = 0.0;
                int n8 = -1;
                for (n7 = this.nsetp; n7 < this.N; ++n7) {
                    n6 = this.index[n7];
                    if (!(this.w[n6] > d3)) continue;
                    d3 = this.w[n6];
                    n8 = n7;
                }
                if (d3 <= 0.0) break block1;
                n7 = n8;
                n6 = this.index[n7];
                double d4 = this.a[this.nsetp][n6];
                d = NonNegativeLeastSquares.constructHouseholderTransform(this.nsetp, this.nsetp + 1, this.a, n6);
                double d5 = 0.0;
                for (n5 = 0; n5 < this.nsetp; ++n5) {
                    d5 += NonNegativeLeastSquares.sqr(this.a[n5][n6]);
                }
                if (NonNegativeLeastSquares.diff((d5 = Math.sqrt(d5)) + Math.abs(this.a[this.nsetp][n6]) * 0.01, d5) > 0.0) {
                    System.arraycopy(this.b, 0, this.zz, 0, this.M);
                    NonNegativeLeastSquares.applyHouseholderTransform(this.nsetp, this.nsetp + 1, this.a, n6, d, this.zz);
                    double d6 = this.zz[this.nsetp] / this.a[this.nsetp][n6];
                    if (d6 > 0.0) break;
                }
                this.a[this.nsetp][n6] = d4;
                this.w[n6] = 0.0;
            }
            System.arraycopy(this.zz, 0, this.b, 0, this.M);
            this.index[n7] = this.index[this.nsetp];
            this.index[this.nsetp] = n6;
            int n9 = -1;
            for (int i = ++this.nsetp; i < this.N; ++i) {
                n9 = this.index[i];
                NonNegativeLeastSquares.applyHouseholderTransform(this.nsetp - 1, this.nsetp, this.a, n6, d, this.a, n9);
            }
            for (n5 = this.nsetp; n5 < this.M; ++n5) {
                this.a[n5][n6] = 0.0;
            }
            this.w[n6] = 0.0;
            for (n5 = 0; n5 < this.nsetp; ++n5) {
                n4 = this.nsetp - n5;
                if (n5 != 0) {
                    for (n3 = 0; n3 < n4; ++n3) {
                        int n10 = n3;
                        this.zz[n10] = this.zz[n10] - this.a[n3][n9] * this.zz[n4];
                    }
                }
                n9 = this.index[--n4];
                int n11 = n4;
                this.zz[n11] = this.zz[n11] / this.a[n4][n9];
            }
            block11: while (true) {
                if (++n2 > this.itmax) {
                    throw new IllegalStateException("NonNegativeLeastSquares.solve(): Too many iterations");
                }
                double d7 = 2.0;
                for (n4 = 0; n4 < this.nsetp; ++n4) {
                    double d8;
                    n5 = this.index[n4];
                    if (!(this.zz[n4] <= 0.0) || !(d7 > (d8 = -this.x[n5] / (this.zz[n4] - this.x[n5])))) continue;
                    d7 = d8;
                    n9 = n4;
                }
                if (d7 == 2.0) break;
                for (n4 = 0; n4 < this.nsetp; ++n4) {
                    int n12 = n5 = this.index[n4];
                    this.x[n12] = this.x[n12] + d7 * (this.zz[n4] - this.x[n5]);
                }
                n = this.index[n9];
                block14: while (true) {
                    this.x[n] = 0.0;
                    if (n9 != this.nsetp - 1) {
                        for (n6 = ++n9; n6 < this.nsetp; ++n6) {
                            double d9;
                            this.index[n6 - 1] = n3 = this.index[n6];
                            this.a[n6 - 1][n3] = NonNegativeLeastSquares.computeGivensRotation(this.a[n6 - 1][n3], this.a[n6][n3], this.terms);
                            this.a[n6][n3] = 0.0;
                            double d10 = this.terms[0];
                            double d11 = this.terms[1];
                            for (n5 = 0; n5 < this.N; ++n5) {
                                if (n5 == n3) continue;
                                d9 = this.a[n6 - 1][n5];
                                this.a[n6 - 1][n5] = d10 * d9 + d11 * this.a[n6][n5];
                                this.a[n6][n5] = -d11 * d9 + d10 * this.a[n6][n5];
                            }
                            d9 = this.b[n6 - 1];
                            this.b[n6 - 1] = d10 * d9 + d11 * this.b[n6];
                            this.b[n6] = -d11 * d9 + d10 * this.b[n6];
                        }
                    }
                    --this.nsetp;
                    this.index[this.nsetp] = n;
                    for (n9 = 0; n9 < this.nsetp; ++n9) {
                        n = this.index[n9];
                        if (this.x[n] <= 0.0) continue block14;
                    }
                    break;
                }
                System.arraycopy(this.b, 0, this.zz, 0, this.M);
                n5 = 0;
                while (true) {
                    if (n5 >= this.nsetp) continue block11;
                    n4 = this.nsetp - n5;
                    if (n5 != 0) {
                        for (n3 = 0; n3 < n4; ++n3) {
                            int n13 = n3;
                            this.zz[n13] = this.zz[n13] - this.a[n3][n9] * this.zz[n4];
                        }
                    }
                    n9 = this.index[--n4];
                    int n14 = n4;
                    this.zz[n14] = this.zz[n14] / this.a[n4][n9];
                    ++n5;
                }
                break;
            }
            for (n4 = 0; n4 < this.nsetp; ++n4) {
                n = this.index[n4];
                this.x[n] = this.zz[n4];
            }
        }
        this.normsqr = 0.0;
        for (n = this.nsetp; n < this.M; ++n) {
            this.normsqr += NonNegativeLeastSquares.sqr(this.b[n]);
        }
    }

    private static double constructHouseholderTransform(int n, int n2, double[][] dArray, int n3) {
        int n4;
        int n5 = dArray.length;
        double d = Math.abs(dArray[n][n3]);
        for (n4 = n2; n4 < n5; ++n4) {
            d = Math.max(Math.abs(dArray[n4][n3]), d);
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares.constructHouseholderTransform(): Illegal pivot vector");
        }
        double d2 = 1.0 / d;
        double d3 = NonNegativeLeastSquares.sqr(dArray[n][n3] * d2);
        for (n4 = n2; n4 < n5; ++n4) {
            d3 += NonNegativeLeastSquares.sqr(dArray[n4][n3] * d2);
        }
        d *= Math.sqrt(d3);
        if (dArray[n][n3] > 0.0) {
            d = -d;
        }
        double d4 = dArray[n][n3] - d;
        dArray[n][n3] = d;
        return d4;
    }

    private static void applyHouseholderTransform(int n, int n2, double[][] dArray, int n3, double d, double[][] dArray2, int n4) {
        int n5;
        int n6 = dArray.length;
        double d2 = Math.abs(dArray[n][n3]);
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares.applyHouseholderTransform(): Illegal pivot vector");
        }
        double d3 = d * dArray[n][n3];
        if (d3 == 0.0) {
            return;
        }
        if (d3 > 0.0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares.applyHouseholderTransform(): Illegal pivot element");
        }
        d3 = 1.0 / d3;
        double d4 = dArray2[n][n4] * d;
        for (n5 = n2; n5 < n6; ++n5) {
            d4 += dArray2[n5][n4] * dArray[n5][n3];
        }
        if (d4 != 0.0) {
            double[] dArray3 = dArray2[n];
            int n7 = n4;
            dArray3[n7] = dArray3[n7] + (d4 *= d3) * d;
            for (n5 = n2; n5 < n6; ++n5) {
                double[] dArray4 = dArray2[n5];
                int n8 = n4;
                dArray4[n8] = dArray4[n8] + d4 * dArray[n5][n3];
            }
        }
    }

    private static void applyHouseholderTransform(int n, int n2, double[][] dArray, int n3, double d, double[] dArray2) {
        int n4;
        int n5 = dArray.length;
        double d2 = Math.abs(dArray[n][n3]);
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares.applyHouseholderTransform(): Illegal pivot vector");
        }
        double d3 = d * dArray[n][n3];
        if (d3 == 0.0) {
            return;
        }
        if (d3 > 0.0) {
            throw new IllegalArgumentException("NonNegativeLeastSquares.applyHouseholderTransform(): Illegal pivot element");
        }
        d3 = 1.0 / d3;
        double d4 = dArray2[n] * d;
        for (n4 = n2; n4 < n5; ++n4) {
            d4 += dArray2[n4] * dArray[n4][n3];
        }
        if (d4 != 0.0) {
            int n6 = n;
            dArray2[n6] = dArray2[n6] + (d4 *= d3) * d;
            for (n4 = n2; n4 < n5; ++n4) {
                int n7 = n4;
                dArray2[n7] = dArray2[n7] + d4 * dArray[n4][n3];
            }
        }
    }

    private static double computeGivensRotation(double d, double d2, double[] dArray) {
        if (Math.abs(d) > Math.abs(d2)) {
            double d3 = d2 / d;
            double d4 = Math.sqrt(1.0 + NonNegativeLeastSquares.sqr(d3));
            dArray[0] = NonNegativeLeastSquares.sign(1.0 / d4, d);
            dArray[1] = dArray[0] * d3;
            return Math.abs(d) * d4;
        }
        if (d2 != 0.0) {
            double d5 = d / d2;
            double d6 = Math.sqrt(1.0 + NonNegativeLeastSquares.sqr(d5));
            dArray[1] = NonNegativeLeastSquares.sign(1.0 / d6, d2);
            dArray[0] = dArray[1] * d5;
            return Math.abs(d2) * d6;
        }
        dArray[0] = 0.0;
        dArray[1] = 1.0;
        return 0.0;
    }

    private static double diff(double d, double d2) {
        return d - d2;
    }

    private static double sqr(double d) {
        return d * d;
    }

    private static double sign(double d, double d2) {
        return d2 >= 0.0 ? d : -d;
    }
}

