/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Series;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Scanner;

public class ListSeries
extends Series
implements Externalizable {
    private static final long serialVersionUID = 1521857061875435370L;
    private static final int INCR = 16;
    private double[] xArray = new double[16];
    private int myLength = 0;

    public int length() {
        return this.myLength;
    }

    public double x(int n) {
        if (0 > n || n >= this.myLength) {
            throw new ArrayIndexOutOfBoundsException("ListSeries.x(): Index = " + n + " out of bounds");
        }
        return this.xArray[n];
    }

    public ListSeries clear() {
        this.myLength = 0;
        return this;
    }

    public ListSeries add(double d) {
        this.allocate(1, 16);
        this.xArray[this.myLength] = d;
        ++this.myLength;
        return this;
    }

    public ListSeries add(double[] dArray) {
        return this.add(dArray, 0, dArray.length);
    }

    public ListSeries add(double[] dArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > dArray.length) {
            throw new IndexOutOfBoundsException();
        }
        this.allocate(n2, n2);
        System.arraycopy(dArray, n, this.xArray, this.myLength, n2);
        this.myLength += n2;
        return this;
    }

    public ListSeries add(Series series) {
        return this.add(series, 0, series.length());
    }

    public ListSeries add(Series series, int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > series.length()) {
            throw new IndexOutOfBoundsException();
        }
        this.allocate(n2, n2);
        while (n2 > 0) {
            this.xArray[this.myLength] = series.x(n);
            ++this.myLength;
            ++n;
            --n2;
        }
        return this;
    }

    public ListSeries add(Scanner scanner) {
        while (scanner.hasNextDouble()) {
            this.add(scanner.nextDouble());
        }
        return this;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.myLength;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.xArray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.xArray = new double[n];
        this.myLength = n;
        for (int i = 0; i < n; ++i) {
            this.xArray[i] = objectInput.readDouble();
        }
    }

    private void allocate(int n, int n2) {
        if (this.myLength + n > this.xArray.length) {
            double[] dArray = new double[this.myLength + n2];
            System.arraycopy(this.xArray, 0, dArray, 0, this.myLength);
            this.xArray = dArray;
        }
    }
}

