/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.Function;
import edu.rit.numeric.ListXYSeries;
import edu.rit.numeric.XYSeries;

public class Interpolation
implements Function {
    private ListXYSeries mySeries;
    private int myLengthMinus1;
    private int myIndex;
    private double x1;
    private double y1;
    private double x2;
    private double y2;

    public Interpolation(XYSeries xYSeries) {
        if (xYSeries.length() < 2) {
            throw new IllegalArgumentException("Interpolation(): theSeries length < 2");
        }
        this.mySeries = new ListXYSeries().add(xYSeries);
        this.myLengthMinus1 = this.mySeries.length() - 1;
        this.myIndex = 0;
        this.x1 = this.mySeries.x(0);
        this.y1 = this.mySeries.y(0);
        this.x2 = this.mySeries.x(1);
        this.y2 = this.mySeries.y(1);
    }

    public double f(double d) {
        while (this.myIndex < this.myLengthMinus1 && d >= this.x2) {
            ++this.myIndex;
            this.x1 = this.x2;
            this.y1 = this.y2;
            this.x2 = this.mySeries.x(this.myIndex);
            this.y2 = this.mySeries.y(this.myIndex);
        }
        while (this.myIndex > 0 && d < this.x1) {
            --this.myIndex;
            this.x2 = this.x1;
            this.y2 = this.y1;
            this.x1 = this.mySeries.x(this.myIndex);
            this.y1 = this.mySeries.y(this.myIndex);
        }
        double d2 = (d - this.x1) / (this.x2 - this.x1);
        return (1.0 - d2) * this.y1 + d2 * this.y2;
    }

    public double fInv(double d) {
        while (this.myIndex < this.myLengthMinus1 && d >= this.y2) {
            ++this.myIndex;
            this.x1 = this.x2;
            this.y1 = this.y2;
            this.x2 = this.mySeries.x(this.myIndex);
            this.y2 = this.mySeries.y(this.myIndex);
        }
        while (this.myIndex > 0 && d < this.y1) {
            --this.myIndex;
            this.x2 = this.x1;
            this.y2 = this.y1;
            this.x1 = this.mySeries.x(this.myIndex);
            this.y1 = this.mySeries.y(this.myIndex);
        }
        double d2 = (d - this.y1) / (this.y2 - this.y1);
        return (1.0 - d2) * this.x1 + d2 * this.x2;
    }
}

