/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Signed8BitIntegerBuf;
import edu.rit.mp.buf.Signed8BitIntegerMatrixBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

class Signed8BitIntegerMatrixReductionBuf
extends Signed8BitIntegerMatrixBuf {
    IntegerOp myOp;

    public Signed8BitIntegerMatrixReductionBuf(int[][] nArray, Range range, Range range2, IntegerOp integerOp) {
        super(nArray, range, range2);
        if (integerOp == null) {
            throw new NullPointerException("Signed8BitIntegerMatrixReductionBuf(): op is null");
        }
        this.myOp = integerOp;
    }

    public void put(int n, int n2) {
        int n3 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n4 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n3][n4] = this.myOp.op(this.myMatrix[n3][n4], n2);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof Signed8BitIntegerMatrixBuf) {
                Signed8BitIntegerMatrixBuf signed8BitIntegerMatrixBuf = (Signed8BitIntegerMatrixBuf)buf;
                ReduceArrays.reduce(signed8BitIntegerMatrixBuf.myMatrix, signed8BitIntegerMatrixBuf.myRowRange, signed8BitIntegerMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                Signed8BitIntegerBuf.defaultCopy((Signed8BitIntegerBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, byteBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            int[] nArray = this.myMatrix[n5];
            while (n6 < n8) {
                nArray[n7] = this.myOp.op(nArray[n7], byteBuffer.get());
                ++n6;
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, byteBuffer.remaining());
        }
        return n3;
    }
}

