/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortMatrixBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ReduceArrays;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Range;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;

class ShortMatrixReductionBuf
extends ShortMatrixBuf {
    ShortOp myOp;

    public ShortMatrixReductionBuf(short[][] sArray, Range range, Range range2, ShortOp shortOp) {
        super(sArray, range, range2);
        if (shortOp == null) {
            throw new NullPointerException("ShortMatrixReductionBuf(): op is null");
        }
        this.myOp = shortOp;
    }

    public void put(int n, short s) {
        int n2 = n / this.myColCount * this.myRowStride + this.myLowerRow;
        int n3 = n % this.myColCount * this.myColStride + this.myLowerCol;
        this.myMatrix[n2][n3] = this.myOp.op(this.myMatrix[n2][n3], s);
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ShortMatrixBuf) {
                ShortMatrixBuf shortMatrixBuf = (ShortMatrixBuf)buf;
                ReduceArrays.reduce(shortMatrixBuf.myMatrix, shortMatrixBuf.myRowRange, shortMatrixBuf.myColRange, this.myMatrix, this.myRowRange, this.myColRange, this.myOp);
            } else {
                ShortBuf.defaultCopy((ShortBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        ShortBuffer shortBuffer = byteBuffer.asShortBuffer();
        int n3 = 0;
        int n4 = n / this.myColCount;
        int n5 = n4 * this.myRowStride + this.myLowerRow;
        int n6 = n % this.myColCount;
        int n7 = n6 * this.myColStride + this.myLowerCol;
        int n8 = Math.min(this.myColCount - n6, shortBuffer.remaining());
        while (n4 < this.myRowCount && n8 > 0) {
            short[] sArray = this.myMatrix[n5];
            while (n6 < n8) {
                sArray[n7] = this.myOp.op(sArray[n7], shortBuffer.get());
                ++n6;
                n7 += this.myColStride;
            }
            n3 += n8;
            ++n4;
            n5 += this.myRowStride;
            n6 = 0;
            n7 = this.myLowerCol;
            n8 = Math.min(this.myColCount, shortBuffer.remaining());
        }
        byteBuffer.position(byteBuffer.position() + 2 * n3);
        return n3;
    }
}

