/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortItemBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ShortOp;
import java.nio.ByteBuffer;

class ShortItemReductionBuf
extends ShortBuf {
    ShortItemBuf myBuf;
    ShortOp myOp;

    public ShortItemReductionBuf(ShortItemBuf shortItemBuf, ShortOp shortOp) {
        super(1);
        if (shortItemBuf == null) {
            throw new NullPointerException("ShortItemReductionBuf(): buf is null");
        }
        if (shortOp == null) {
            throw new NullPointerException("ShortItemReductionBuf(): op is null");
        }
        this.myBuf = shortItemBuf;
        this.myOp = shortOp;
    }

    public short get(int n) {
        return this.myBuf.item;
    }

    public void put(int n, short s) {
        this.myBuf.item = this.myOp.op(this.myBuf.item, s);
    }

    public Buf getReductionBuf(Op op) {
        throw new UnsupportedOperationException();
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 2) {
            byteBuffer.putShort(this.myBuf.item);
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 2) {
            this.myBuf.item = this.myOp.op(this.myBuf.item, byteBuffer.getShort());
            return 1;
        }
        return 0;
    }
}

