/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.ShortArrayReductionBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.ShortOp;
import edu.rit.util.Arrays;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class ShortArrayBuf
extends ShortBuf {
    short[] myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public ShortArrayBuf(short[] sArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= sArray.length) {
            throw new IndexOutOfBoundsException("ShortArrayBuf(): theArray index range = 0.." + (sArray.length - 1) + ", theRange = " + range);
        }
        this.myArray = sArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public short get(int n) {
        return this.myArray[this.myArrayOffset + n * this.myStride];
    }

    public void put(int n, short s) {
        this.myArray[this.myArrayOffset + n * this.myStride] = s;
    }

    public void copy(Buf buf) {
        if (buf != this) {
            if (buf instanceof ShortArrayBuf) {
                ShortArrayBuf shortArrayBuf = (ShortArrayBuf)buf;
                Arrays.copy(shortArrayBuf.myArray, shortArrayBuf.myRange, this.myArray, this.myRange);
            } else {
                ShortBuf.defaultCopy((ShortBuf)buf, this);
            }
        }
    }

    public Buf getReductionBuf(Op op) {
        return new ShortArrayReductionBuf(this.myArray, this.myRange, (ShortOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 2) {
            byteBuffer.putShort(this.myArray[n3]);
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 2) {
            this.myArray[n4] = byteBuffer.getShort();
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

