/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Unsigned16BitIntegerBuf;
import edu.rit.mp.buf.SharedUnsigned16BitIntegerReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedInteger;
import java.nio.ByteBuffer;

public class SharedUnsigned16BitIntegerBuf
extends Unsigned16BitIntegerBuf {
    SharedInteger myItem;

    public SharedUnsigned16BitIntegerBuf(SharedInteger sharedInteger) {
        super(1);
        if (sharedInteger == null) {
            throw new NullPointerException("SharedUnsigned16BitIntegerBuf(): item is null");
        }
        this.myItem = sharedInteger;
    }

    public int get(int n) {
        return this.myItem.get();
    }

    public void put(int n, int n2) {
        this.myItem.set(n2);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedUnsigned16BitIntegerReductionBuf(this.myItem, (IntegerOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 2) {
            byteBuffer.putShort((short)this.myItem.get());
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 2) {
            this.myItem.set(byteBuffer.getShort() & 0xFFFF);
            return 1;
        }
        return 0;
    }
}

