/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Unsigned16BitIntegerBuf;
import edu.rit.mp.buf.SharedUnsigned16BitIntegerArrayReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedIntegerArray;
import edu.rit.util.Range;
import java.nio.ByteBuffer;

public class SharedUnsigned16BitIntegerArrayBuf
extends Unsigned16BitIntegerBuf {
    SharedIntegerArray myArray;
    Range myRange;
    int myArrayOffset;
    int myStride;

    public SharedUnsigned16BitIntegerArrayBuf(SharedIntegerArray sharedIntegerArray, Range range) {
        super(range.length());
        if (0 > range.lb() || range.ub() >= sharedIntegerArray.length()) {
            throw new IndexOutOfBoundsException("SharedUnsigned16BitIntegerArrayBuf(): theArray index range = 0.." + (sharedIntegerArray.length() - 1) + ", theRange = " + range);
        }
        this.myArray = sharedIntegerArray;
        this.myRange = range;
        this.myArrayOffset = range.lb();
        this.myStride = range.stride();
    }

    public int get(int n) {
        return this.myArray.get(this.myArrayOffset + n * this.myStride);
    }

    public void put(int n, int n2) {
        this.myArray.set(this.myArrayOffset + n * this.myStride, n2);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedUnsigned16BitIntegerArrayReductionBuf(this.myArray, this.myRange, (IntegerOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        int n2 = n;
        int n3 = this.myArrayOffset + n * this.myStride;
        while (n2 < this.myLength && byteBuffer.remaining() >= 2) {
            byteBuffer.putShort((short)this.myArray.get(n3));
            ++n2;
            n3 += this.myStride;
        }
        return n2 - n;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        int n3 = n;
        int n4 = this.myArrayOffset + n * this.myStride;
        int n5 = Math.min(n + n2, this.myLength);
        while (n3 < n5 && byteBuffer.remaining() >= 2) {
            this.myArray.set(n4, byteBuffer.getShort() & 0xFFFF);
            ++n3;
            n4 += this.myStride;
        }
        return n3 - n;
    }
}

