/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.Signed16BitIntegerBuf;
import edu.rit.mp.buf.SharedSigned16BitIntegerReductionBuf;
import edu.rit.pj.reduction.IntegerOp;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedInteger;
import java.nio.ByteBuffer;

public class SharedSigned16BitIntegerBuf
extends Signed16BitIntegerBuf {
    SharedInteger myItem;

    public SharedSigned16BitIntegerBuf(SharedInteger sharedInteger) {
        super(1);
        if (sharedInteger == null) {
            throw new NullPointerException("SharedSigned16BitIntegerBuf(): item is null");
        }
        this.myItem = sharedInteger;
    }

    public int get(int n) {
        return this.myItem.get();
    }

    public void put(int n, int n2) {
        this.myItem.set(n2);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedSigned16BitIntegerReductionBuf(this.myItem, (IntegerOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 2) {
            byteBuffer.putShort((short)this.myItem.get());
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 2) {
            this.myItem.set(byteBuffer.getShort());
            return 1;
        }
        return 0;
    }
}

