/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.mp.buf;

import edu.rit.mp.Buf;
import edu.rit.mp.ShortBuf;
import edu.rit.mp.buf.SharedShortReductionBuf;
import edu.rit.pj.reduction.Op;
import edu.rit.pj.reduction.SharedShort;
import edu.rit.pj.reduction.ShortOp;
import java.nio.ByteBuffer;

public class SharedShortBuf
extends ShortBuf {
    SharedShort myItem;

    public SharedShortBuf(SharedShort sharedShort) {
        super(1);
        if (sharedShort == null) {
            throw new NullPointerException("SharedShortBuf(): item is null");
        }
        this.myItem = sharedShort;
    }

    public short get(int n) {
        return this.myItem.get();
    }

    public void put(int n, short s) {
        this.myItem.set(s);
    }

    public Buf getReductionBuf(Op op) {
        return new SharedShortReductionBuf(this.myItem, (ShortOp)op);
    }

    protected int sendItems(int n, ByteBuffer byteBuffer) {
        if (byteBuffer.remaining() >= 2) {
            byteBuffer.putShort(this.myItem.get());
            return 1;
        }
        return 0;
    }

    protected int receiveItems(int n, int n2, ByteBuffer byteBuffer) {
        if (n2 >= 1 && byteBuffer.remaining() >= 2) {
            this.myItem.set(byteBuffer.getShort());
            return 1;
        }
        return 0;
    }
}

